import React, { useState } from "react";
import Chats from "./Chats";
import Massages from "./Massages";
import "./ChatComponent.css";
import PropTypes from "prop-types";
import useResponsive from "../../hooks/useResponsive";

const ChatComponent = ({ ChatList, messages, setProperty, logo, field }) => {
  const [toggle, setToggle] = useState(null);

  const isDesktop = useResponsive("up", "lg");

  function closeMessages() {
    setToggle(null);
    setProperty(null);
  }

  return (
    <div className="ChatComponent">
      {isDesktop ? (
        <div style={{ display: "flex" }}>
          <div style={{ width: "30%", maxWidth: "30%" }}>
            <Chats
              field={field}
              ChatList={ChatList}
              setProperty={setProperty}
              setToggle={setToggle}
            />
          </div>
          <div className="vl"></div>
          <div style={{ width: "69.5%", minWidth: "69.5" }}>
            <Massages
              closeToggle={closeMessages}
              messages={messages}
              logo={logo}
            />
          </div>
        </div>
      ) : toggle ? (
        <Massages closeToggle={closeMessages} messages={messages} logo={logo} />
      ) : (
        <Chats
          field={field}
          ChatList={ChatList}
          setProperty={setProperty}
          setToggle={setToggle}
        />
      )}
    </div>
  );
};

ChatComponent.propTypes = {
  ChatList: PropTypes.array,
  messages: PropTypes.array,
  setProperty: PropTypes.func,
  logo: PropTypes.string,
  field: PropTypes.string,
};

export default ChatComponent;
