import React from "react";
import { Avatar, Box, Typography } from "@mui/material";
import Scrollbar from "../Scrollbar";
import PropTypes from "prop-types";

Chats.propTypes = {
  ChatList: PropTypes.array,
  setToggle: PropTypes.func,
  setProperty: PropTypes.func,
  field: PropTypes.string,
};

function Chats({ ChatList, setToggle, setProperty, field }) {
  return (
    <Box
      component="div"
      sx={{
        width: "100%",
        height: "65vh",
        overflow: "hidden",
        cursor: "pointer",
        padding: "3%",
      }}
    >
      <Scrollbar>
        {ChatList?.map((data) => {
          return (
            //We will change the key to id which will come from massage data;
            <Box
              component="div"
              key={data.id}
              onClick={() => {
                setToggle(true);
                setProperty(data[field]);
              }}
            >
              <ChatsRow chat={data} />
            </Box>
          );
        })}
      </Scrollbar>
    </Box>
  );
}

const ChatsRow = ({ chat }) => {
  return (
    <Box component="div" sx={{ padding: "5px", display: "flex" }}>
      <Avatar
        sx={{ alignSelf: "center" }}
        alt="avatar"
        src="/static/icons/user.png"
      />
      <Box component="div" sx={{ margin: "0px 5px", width: "100%" }}>
        <Typography
          variant="h7"
          component="h7"
          sx={{
            display: "-webkit-box",
            overflow: "hidden",
            WebkitBoxOrient: "vertical",
            WebkitLineClamp: 1,
          }}
        >
          {chat.contact_name}
        </Typography>
        <Typography
          variant="p"
          component="p"
          sx={{
            display: "-webkit-box",
            overflow: "hidden",
            WebkitBoxOrient: "vertical",
            WebkitLineClamp: 1,
          }}
        >
          {chat.message}
        </Typography>
      </Box>
    </Box>
  );
};
ChatsRow.propTypes = {
  chat: PropTypes.oneOfType({
    contact_name: PropTypes.string,
    message: PropTypes.string,
  }),
};
export default Chats;
