import React from "react";
import "./Massages.css";

import { Cancel } from "@material-ui/icons";
import useResponsive from "../../hooks/useResponsive";
import Scrollbar from "../Scrollbar";
import { Box, Divider, Typography } from "@mui/material";
import PropTypes from "prop-types";

const Massages = ({ messages, closeToggle, logo }) => {
  const isDesktop = useResponsive("up", "lg");

  return (
    //We will change the key to id which will come from massage data;

    <Box sx={{ display: "block", width: "100%" }}>
      {isDesktop ? null : (
        <Cancel style={{ cursor: "pointer" }} onClick={closeToggle}></Cancel>
      )}
      <Box sx={{ width: "100%", height: "65vh", overflowX: "hidden" }}>
        <Scrollbar>
          {messages.length ? (
            messages?.map((msg, index, arry) => {
              return (
                <Box sx={{ width: "100%" }} key={index}>
                  {/*  Mannaging Date */}
                  {index === 0 ? (
                    <DateShower date={msg.date_time} />
                  ) : new Date(arry[index - 1].date_time).toDateString() !==
                    new Date(arry[index].date_time).toDateString() ? (
                    <DateShower date={msg.date_time} />
                  ) : null}
                  {msg.status === "1" ? (
                    <MsgRowLeft msg={msg} />
                  ) : (
                    <MsgRowRight msg={msg} />
                  )}
                </Box>
              );
            })
          ) : (
            <Box>
              <img
                style={{
                  width: "50%",
                  height: "50%",
                  margin: "12% auto auto auto",
                  opacity: "0.5",
                }}
                src={logo}
              />
            </Box>
          )}
        </Scrollbar>
      </Box>
    </Box>
  );
};

const DateShower = ({ date }) => {
  // hare we will write the logic for show or hide the date
  return (
    <Box
      sx={{
        marginBottom: "10px",
      }}
    >
      <Box
        sx={{
          display: "flex",
          padding: "5px",
        }}
      >
        <Typography component="p" variant="p">
          {new Date(date).toDateString()}
        </Typography>
      </Box>
      <Divider />
    </Box>
  );
};

const MsgRowRight = ({ msg }) => {
  return (
    <div className="rightMsgRow">
      <p className="massageText">
        <p style={{ textAlign: "left" }}>{msg.message}</p>
      </p>
      <p>{`${new Date(msg.date_time).toLocaleTimeString()}`}</p>
    </div>
  );
};

const MsgRowLeft = ({ msg }) => {
  return (
    <Box className="leftMsgRow">
      <p className="massageText">{msg.message}</p>
      <p>{`${new Date(msg.date_time).toLocaleTimeString()}`}</p>
    </Box>
  );
};

MsgRowRight.propTypes = {
  msg: PropTypes.oneOfType({
    message: PropTypes.string,
    date_time: PropTypes.number,
  }),
};
MsgRowLeft.propTypes = {
  msg: PropTypes.oneOfType({
    message: PropTypes.string,
    date_time: PropTypes.number,
  }),
};
DateShower.propTypes = {
  date: PropTypes.number,
};
Massages.propTypes = {
  messages: PropTypes.array,
  closeToggle: PropTypes.func,
  logo: PropTypes.string,
};
export default Massages;
