import ReactDOM from "react-dom";
import React from "react";
const PayPalButton = window.paypal?.Buttons.driver("react", {
  React,
  ReactDOM,
});
import PropTypes from "prop-types";

const PayPatCheckOut = ({ cost_price, sumbitDetails }) => {
  const createOrder = (data, actions) => {
    return actions.order.create({
      purchase_units: [
        {
          custom_id: "55",
          description: "Some description",
          amount: {
            currency_code: "USD",
            value: cost_price,
          },
        },
      ],
    });
  };

  const onApprove = (data, actions) => {
    return actions.order.capture().then((details) => {
      sumbitDetails(details, "PAYPAL");
    });
  };

  return (
    <>
      {PayPalButton ? (
        <PayPalButton
          style={{ layout: "horizontal", tagline: "false" }}
          createOrder={(data, actions) => createOrder(data, actions)}
          onApprove={(data, actions) => onApprove(data, actions)}
        />
      ) : (
        <></>
      )}
    </>
  );
};

PayPatCheckOut.propTypes = {
  cost_price: PropTypes.number,
  sumbitDetails: PropTypes.func,
};

export default PayPatCheckOut;
