import React from 'react';
import {
  ElementsConsumer,
  CardElement,
  Elements,
} from '@stripe/react-stripe-js';
import { Box, Button } from '@mui/material';
import axios from 'axios';
import { loadStripe } from '@stripe/stripe-js';

const stripePromise = loadStripe(
  'pk_test_51JuDqCAqh7AKIhCaTyMcqyK7U2siYseiApyMYyOgHyV07QZX6diFnGgsTCrQXzRR2DWfogkRcpVU6yaNxhcQKzSL006kLMKTX1'
);

const StripeCheckOut = ({ stripe, elements, submit, planId, details }) => {
  async function checkOut(id) {
    console.log(planId);
    try {
      // const result = await axios.post('checkout', null, {
      //   params: {
      //     token: id,
      //     planId: planId,
      //     details: details,
      //   },
      // });
      submit(id, 'STRIPE');
    } catch (error) {
      console.log(error);
    }
  }
  const handleSubmit = async (event) => {
    event.preventDefault();
    try {
      if (!stripe || !elements) return;

      const card = elements.getElement(CardElement);
      const result = await stripe.createToken(card);

      checkOut(result.token.id);
    } catch (error) {
      console.log(error.message);
    }
  };
  return (
    <Box sx={{ minWidth: '300px', margin: '15px' }}>
      <form onSubmit={handleSubmit}>
        <CardSection />
        <Button type='submit'>Buy Now</Button>
      </form>
    </Box>
  );
};

const CARD_ELEMENT_OPTIONS = {
  iconStyle: 'solid',
  hidePostalCode: true,
  style: {
    base: {
      iconColor: 'rgb(240, 57, 122)',
      color: 'rgb(240, 57, 122)',
      fontSize: '16px',
      fontFamily: '"Open Sans", sans-serif',
      fontSmoothing: 'antialiased',
      '::placeholder': {
        color: '#CFD7DF',
      },
    },
    invalid: {
      color: '#e5424d',
      ':focus': {
        color: '#303238',
      },
    },
  },
};

function CardSection() {
  return <CardElement options={CARD_ELEMENT_OPTIONS} />;
}

export default function InjectedCheckoutForm({
  sumbitDetails,
  planId,
  details,
}) {
  return (
    <Elements stripe={stripePromise}>
      <ElementsConsumer>
        {({ stripe, elements }) => (
          <StripeCheckOut
            stripe={stripe}
            elements={elements}
            submit={sumbitDetails}
            details={details}
            planId={planId}
          />
        )}
      </ElementsConsumer>
    </Elements>
  );
}
