import React from 'react';

import { Box, Button, Card, Grid, IconButton } from '@mui/material';
import { Link as RouterLink } from 'react-router-dom';
import QRCode from 'react-qr-code';
import SettingsOutlinedIcon from '@material-ui/icons/SettingsOutlined';
import EqualizerRoundedIcon from '@material-ui/icons/EqualizerRounded';
import GetAppRoundedIcon from '@material-ui/icons/GetAppRounded';
import ReplayRoundedIcon from '@material-ui/icons/ReplayRounded';
import useLanguage from '../../hooks/useLanguage';
import useAuth from '../../hooks/useAuth';
const AllDevices = ({ DevicesList, setDeviceID, deviceID }) => {
  return (
    <>
      {DevicesList.length ? (
        DevicesList.map((item) => {
          return (
            <Device key={item.id} Device={item} setDeviceID={setDeviceID} deviceID={deviceID} />
          );
        })
      ) : (
        <h3 style={{ textAlign: 'center' }}>No Devices Available</h3>
      )}
    </>
  );
};

export const Device = ({ Device, setDeviceID, deviceID }) => {
  const { user } = useAuth();
  const translate = useLanguage().translate;
  return (
    <Card style={{ padding: '30px', margin: '20px 0px', borderRadius: 15 }}>
      <Grid
        container
        spacing={2}
        sx={{ textAlign: { xs: 'center', md: 'left' } }}

      >
        <Grid item xs={12} md={3}>
          <Box
            sx={{
              width: '160px',
              height: '160px',
              margin: 'auto',
            }}
          >
            {!Device.device_token ? (
              <Card
                sx={{
                  width: '160px',
                  height: '160px',
                  textAlign: 'center',
                  margin: 'auto',
                  backgroundColor: 'white',
                }}
              >
                <Box sx={{ marginTop: '17px' }}>
                  <QRCode size={82} value={Device.uniqueid + '_' + user.year} />
                  {console.log('Device: ', Device)}
                  <p
                    style={{
                      color: 'black',
                      wordWrap: 'break-word',
                      fontSize: '10px',
                      fontWeight: '400',
                      lineHeight: '14px',
                      margin: '0px 10px',
                      cursor: 'pointer',
                    }}
                    onClick={(e) => {
                      navigator.clipboard.writeText(e.target.innerHTML);
                    }}
                  >
                    {Device.uniqueid}_{user.year}
                  </p>
                </Box>
              </Card>
            ) : (
              <img
                style={{ width: '160px', height: '160px' }}
                src='/images/mobile_icon.png'
              />
            )}
          </Box>
        </Grid>

        <Grid item xs={12} md={4}>
          <Box>
            <p>
              <b>{translate('Name')}: </b>
              {Device.device_status === 'inactive' ? (
                <>
                  {translate('Device')} {Device.id}{' '}
                </>
              ) : (
                Device.android_os
              )}
            </p>
            <p>
              <b>{translate('Status')}: </b>
              {Device.expired !== 'No' ? (
                <>{translate('Expired')}</>
              ) : (
                Device.device_status
              )}
            </p>

            {Device.device_status === 'active' || Device.expired ? (
              <>
                {Device.number && (
                  <p>
                    <b>{translate('Phone No')}: </b>
                    {Device.number}
                  </p>
                )}
                {Device.IMEI && (
                  <p>
                    <b>{translate('IMEI No')} : </b>
                    {Device.IMEI}
                  </p>
                )}
              </>
            ) : null}
          </Box>
        </Grid>

        <Grid item xs={12} md={5}>
          {Device.device_token === null ? (
            <Box sx={{ textAlign: { xs: 'center', md: 'right' } }}>
              <Button
                onClick={() => console.log('Download App')}
                to='#'
                variant='contained'
                sx={{
                  boxShadow: 'none',
                  minWidth: '160px',
                  maxWidth: '160px',
                }}
              >
                <GetAppRoundedIcon />
                {translate('Download app')}
              </Button>
            </Box>
          ) : (
            <Grid container>
              {Device.expired ? (
                <Grid item xs={12} md={6}>
                  <Box sx={{ textAlign: 'center' }}>
                    <Button
                      to={`../renew-plan/${Device.id}/plan`}
                      variant='contained'
                      sx={{
                        boxShadow: 'none',
                        minWidth: '140px',
                        maxWidth: '140px',
                      }}
                      onClick={() => { console.log(`/renew-plan/${Device.id}/plan`) }}
                      component={RouterLink}
                    >
                      <ReplayRoundedIcon />
                      {translate('Renew Plan')}
                    </Button>
                  </Box>
                </Grid>
              ) : <Grid item xs={0} md={4}></Grid>}

              {Device.device_token && (
                <Grid item xs={12} md={4}>
                  <Box sx={{ textAlign: { xs: 'center', md: 'right' } }}>
                    <Button
                      to={`../settings/${Device.id}`}
                      component={RouterLink}
                      sx={{
                        backgroundColor: 'white',
                        border: '0.5px solid #D8D9DC',
                        boxShadow: 'none',
                        '&:hover': {
                          border: '0.5px solid #AFD402',
                        },

                        minWidth: '140px',
                        maxWidth: '140px',
                      }}
                      variant='contained'
                    >
                      <SettingsOutlinedIcon />
                      {translate('Settings')}
                    </Button>
                  </Box>
                </Grid>
              )}

              <Grid item xs={12} md={6}>
                {Device.device_token || (
                  <Box sx={{ textAlign: { xs: 'center', md: 'right' } }}>
                    <Button
                      to={`../spy-app/${Device.id}`}
                      component={RouterLink}
                      sx={{
                        minWidth: '140px',
                        maxWidth: '140px',
                        marginTop: { xs: "15px", md: "0px" },
                        backgroundColor: 'white',
                        border: '0.5px solid #D8D9DC',
                        boxShadow: 'none',
                        '&:hover': {
                          border: '0.5px solid #AFD402',
                        },
                      }}
                      variant='contained'
                    >
                      <EqualizerRoundedIcon />
                      {translate('Dashboard')}
                    </Button>
                  </Box>
                )}
              </Grid>
            </Grid>
          )}
        </Grid>
      </Grid>
    </Card>
  );
};

export default AllDevices;
