import {
    Button,
    Box,
    Modal,
    Card,
    Checkbox,
    FormControlLabel,
    Grid,
  } from "@mui/material";
  import React, { useState } from "react";
  import TextField from "@mui/material/TextField";
  import DialogActions from "@mui/material/DialogActions";
  import DialogContent from "@mui/material/DialogContent";
  import DialogContentText from "@mui/material/DialogContentText";
  import DialogTitle from "@mui/material/DialogTitle";
  
  import axios from "axios";
  
  const FeatureDilog = ({ open, handleClose, update, defaultData }) => {
    const [formData, setFormData] = useState(defaultData);
  
    const [isError, setError] = useState(false);
  
    const handleSubmit = async () => {
      try {
        if (
          !formData.path ||
          !formData.name ||
          !formData.icon
        ) {
          setError(true);
          return;
        }
  
        await axios.post(update?`admin/master-feature-update/${formData.id}`:`admin/master-feature-store`, formData);
  
        handleClose(true);
      } catch (error) {
        console.log(error);
        handleClose();
      }
    };
  
    return (
      <Modal
        open={open}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
      >
        <Card sx={{ width: "50%", margin: "100px auto auto auto" }}>
          <Box
            className="FormLayout"
            sx={{
              width: "100%",
              margin: "auto",
            }}
          >
            <Box>
              <DialogTitle>{update?"Update Feature":"Create Feature"}</DialogTitle>
  
              <DialogContent>
                {isError ? (
                  <DialogContentText color="red">
                    All Fields Must Be Field.
                  </DialogContentText>
                ) : null}
  
                <Grid container spacing={2}>
                  <Grid item xs={6}>
                    <TextField
                      fullWidth
                      autoFocus
                      margin="dense"
                      id="name"
                      variant="outlined"
                      value={formData.name}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          name: e.target.value,
                        }))
                      }
                      aria-errormessage="heklki"
                      label="Name"
                      type="text"
                    />
                  </Grid>
                  <Grid item xs={6}>
                    <Box>
                    <TextField
                      fullWidth
                      margin="dense"
                      id="path"
                      variant="outlined"
                      value={formData.path}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          path: e.target.value,
                        }))
                      }
                      aria-errormessage="heklki"
                      label="Path"
                      type="text"
                    />
                  </Box>
                </Grid>
                <Grid item xs={6}>
                  <TextField
                    fullWidth
                    margin="dense"
                    id="icon"
                    variant="outlined"
                    value={formData.icon}
                    onChange={(e) =>
                      setFormData((data) => ({
                        ...data,
                        icon: e.target.value,
                      }))
                    }
                    aria-errormessage="heklki"
                    label="Icon"
                    type="text"
                  />
                </Grid>
                <Grid item xs={6}>
                  <TextField
                    fullWidth
                    margin="dense"
                    id="parent_id"
                    variant="outlined"
                    value={formData.parent_id}
                    onChange={(e) =>
                      setFormData((data) => ({
                        ...data,
                        parent_id: e.target.value,
                      }))
                    }
                    aria-errormessage="heklki"
                    label="Parent ID"
                    type="number"
                  />
                </Grid>
              </Grid>

              <Box sx={{ display: 'flex' }} >
                <FormControlLabel
                  control={
                    <Checkbox
                      size="large"
                      value={formData.status ? true : false}
                      defaultChecked={formData.status}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          status: e.target.checked ? 1 : 0,
                        }))
                      }
                    />
                  }
                  label="status"
                />
                <FormControlLabel
                  control={
                    <Checkbox
                      size="large"
                      value={formData.management ? true : false}
                      defaultChecked={formData.management}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          management: e.target.checked ? 1 : 0,
                        }))
                      }
                    />
                  }
                  label="management"
                />
              </Box>

              <DialogActions>
                <Button
                  onClick={() => {
                    handleClose();
                  }}
                >
                  Cancel
                </Button>
                <Button onClick={handleSubmit}>{update ? "update" : "Add New"}</Button>
              </DialogActions>
            </DialogContent>
          </Box>
        </Box>
      </Card>
    </Modal>
  );
};

export default FeatureDilog;
