import {
  Button,
  Box,
  FormControl,
  InputLabel,
  Select,
  MenuItem,
  Modal,
  Card,
} from "@mui/material";
import React, { useState } from "react";
import TextField from "@mui/material/TextField";
import DialogActions from "@mui/material/DialogActions";
import DialogContent from "@mui/material/DialogContent";
import DialogContentText from "@mui/material/DialogContentText";
import DialogTitle from "@mui/material/DialogTitle";

import useDeviceId from "../../hooks/useDeviceId";
import axios from "axios";
import MapPicker from "react-google-map-picker";

const FormDilog = ({ open, handleClose }) => {
  const [formData, setFormData] = useState({
    area_name: null,
    latitude: null,
    longitude: null,
    radius: null,
  });

  const [isError, setError] = useState(false);

  const { deviceID, setDeviceID } = useDeviceId();

  const [location, setLocation] = useState({ lat: 10, lng: 106 });
  const [zoom, setZoom] = useState(10);

  function handleChangeLocation(lat, lng) {
    setLocation({ lat: lat, lng: lng });
    setFormData((data) => ({ ...data, latitude: lat, longitude: lng }));
  }

  function handleChangeZoom(newZoom) {
    setZoom(newZoom);
  }

  //

  const handleSubmit = async () => {
    try {
      if (
        !formData.area_name ||
        !formData.latitude ||
        !formData.longitude ||
        !formData.radius
      ) {
        setError(true);
        return;
      }
      await axios.post(`fence-save/${deviceID}`, formData);
      handleClose(true);
    } catch (error) {
      console.log(error);
      handleClose();
    }
  };

  return (
    <Modal
      open={open}
      onClose={handleClose}
      aria-labelledby="modal-modal-title"
      aria-describedby="modal-modal-description"
    >
      <Card style={{ margin: "5% 10% 5% 10%" }}>
        <div
          className="FormLayout"
          style={{
            width: "100%",
            margin: "auto",
          }}
        >
          <MapPicker
            defaultLocation={location}
            zoom={zoom}
            mapTypeId="roadmap"
            style={{ height: "45vh" }}
            onChangeLocation={handleChangeLocation}
            onChangeZoom={handleChangeZoom}
            apiKey={process.env.REACT_APP_GOOGLE_MAP_API_KEY}
          />

          <div>
            <DialogTitle>Add New Geo Fence</DialogTitle>

            <DialogContent>
              {isError ? (
                <DialogContentText color="red">
                  All Fields Must Be Field.
                </DialogContentText>
              ) : null}
              <TextField
                fullWidth
                autoFocus
                margin="dense"
                id="name"
                value={formData.area_name}
                onChange={(e) =>
                  setFormData((data) => ({
                    ...data,
                    area_name: e.target.value,
                  }))
                }
                aria-errormessage="heklki"
                label="Name"
                type="text"
                variant="standard"
              />

              <TextField
                fullWidth
                margin="dense"
                id="latitude"
                placeholder="latitude"
                value={formData.latitude}
                onChange={(e) =>
                  setFormData((data) => ({
                    ...data,
                    latitude: e.target.value,
                  }))
                }
                type="number"
                variant="standard"
              />
              <TextField
                fullWidth
                margin="dense"
                id="longitude"
                placeholder="longitude"
                value={formData.longitude}
                onChange={(e) =>
                  setFormData((data) => ({
                    ...data,
                    longitude: e.target.value,
                  }))
                }
                type="number"
                variant="standard"
              />
              <div style={{display:'flex',justifyContent:'space-between'}}>
              <Box>
                <FormControl style={{ width: "100px", marginTop: "5px" }}>
                  <InputLabel id="demo-simple-select-label">Radius</InputLabel>
                  <Select
                    labelId="demo-simple-select-label"
                    id="demo-simple-select"
                    value={formData.radius}
                    onChange={(e) =>
                      setFormData((data) => ({
                        ...data,
                        radius: e.target.value,
                      }))
                    }
                    label="radius"
                  >
                    <MenuItem value={2}>2Km</MenuItem>
                    <MenuItem value={4}>4Km</MenuItem>
                    <MenuItem value={6}>6Km</MenuItem>
                    <MenuItem value={8}>8Km</MenuItem>
                    <MenuItem value={10}>10Km</MenuItem>
                    <MenuItem value={12}>12Km</MenuItem>
                    <MenuItem value={14}>14Km</MenuItem>
                  </Select>
                </FormControl>
              </Box>
              <DialogActions>
              <Button
                onClick={() => {
                  handleClose();
                }}
              >
                Cancel
              </Button>
              <Button onClick={handleSubmit}>Add New</Button>
            </DialogActions>
            </div>
            </DialogContent>
            
          </div>
        </div>
      </Card>
    </Modal>
  );
};

export default FormDilog;
