import {
  Typography,
  TableContainer,
  Table,
  TableBody,
  TableRow,
  TableCell,
} from '@mui/material';
import React, { useEffect, useState } from 'react';
import Scrollbar from 'src/components/Scrollbar';
import {
  UcListHead,
  UcListToolbar,
} from 'src/sections/@dashboard/utilityComponents';
import Iconify from 'src/components/Iconify';
import SearchNotFound from 'src/components/SearchNotFound';

import useDeviceId from '../../hooks/useDeviceId';
import axios from 'axios';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';

const ResultsFromDevice = () => {
  const [selected, setSelected] = useState([]);
  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('address');
  const [filter, setFilter] = useState('');
  const [totalRow, setTotleRows] = useState(0);
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [fenceList, setFenceList] = useState([]);

  const { deviceID, setDeviceID } = useDeviceId();

  useEffect(async () => {
    try {
      const result = await axios.get(`fence-list/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      setTotleRows(result.data.data.total_count);
      setFenceList(result.data.data.fence_list);
    } catch (error) {
      console.log(error);
    }
  }, [rowsPerPage, page, deviceID, filter]);

  const filterdata = applySortFilter(
    fenceList,
    getComparator(order, orderBy),
    filter
  );

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }
  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD_RESULTS[1].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };
  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = fenceList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };
  const isUserNotFound = fenceList.length === 0;

  const TABLE_HEAD_RESULTS = [
    { id: 'id', label: 'ID', alignRight: false },
    { id: 'area_name', label: 'AREA NAME', alignRight: false },
    { id: 'in_time', label: 'IN TIME', alignRight: false },
    { id: 'out_time', label: 'OUT TIME', alignRight: false },
    { id: 'duration', label: 'DURATION', alignRight: false },
    { id: 'date', label: 'DATE', alignRight: true },
  ];
  return (
    <>
      <UcListToolbar
        onSort={sortAll}
        placeholder='Search By Address...'
        numSelected={selected.length}
        onFilter={(value) => setFilter(value)}
      />
      <Scrollbar>
        <>
          <TableContainer sx={{ minWidth: 800 }}>
            <Table>
              <UcListHead
                order={order}
                orderBy={orderBy}
                headLabel={TABLE_HEAD_RESULTS}
                rowCount={fenceList.length}
                numSelected={selected.length}
                onRequestSort={handleRequestSort}
                onSelectAllClick={handleSelectAllClick}
              />
              <TableBody>
                {filterdata.map((row) => {
                  const {
                    id,
                    name,
                    in_time,
                    out_time,
                    duration,
                    date,
                  } = row;
                  const isItemSelected = selected.indexOf(id) !== -1;

                  return (
                    <TableRow
                      hover
                      key={id}
                      tabIndex={-1}
                      role='checkbox'
                      selected={isItemSelected}
                      aria-checked={isItemSelected}
                    >
                      <AlignedTableCell flow='left'>
                        {id}
                      </AlignedTableCell>
                      <AlignedTableCell flow='left'>
                        <Typography variant='subtitle2' noWrap>
                          <Iconify icon='akar-icons:location' />
                          {name}
                        </Typography>
                      </AlignedTableCell>
                      <AlignedTableCell flow='left'>{in_time}</AlignedTableCell>
                      <AlignedTableCell flow='left'>
                        {out_time}
                      </AlignedTableCell>
                      <AlignedTableCell flow='left'>
                        {duration}
                      </AlignedTableCell>
                      <AlignedTableCell flow='right'>{date}</AlignedTableCell>
                    </TableRow>
                  );
                })}
              </TableBody>
              {isUserNotFound && (
                <TableBody>
                  <TableRow>
                    <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                      <SearchNotFound searchQuery={filter} />
                    </TableCell>
                  </TableRow>
                </TableBody>
              )}
            </Table>
          </TableContainer>
        </>
      </Scrollbar>

      <MyTablePagination
        count={totalRow}
        rowsPerPage={rowsPerPage}
        page={page}
        setPage={setPage}
        setRowsPerPage={setRowsPerPage}
      />
    </>
  );
};

export default ResultsFromDevice;
