import {
  Button,
  Checkbox,
  Modal,
  Stack,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableRow,
  Typography,
} from '@mui/material';
import { Box } from '@mui/system';
import React, { useState } from 'react';
import {
  UcListHead,
  UcListToolbar,
} from 'src/sections/@dashboard/utilityComponents';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';
import Iconify from '../Iconify';
import Scrollbar from '../Scrollbar';
import SearchNotFound from '../SearchNotFound';

const TABLE_HEAD = [
  { id: 'view', label: 'VIEW', alignRight: false },
  { id: 'sender', label: 'MAIL', alignRight: false },
  { id: 'date_time', label: 'DATE & TIME', alignRight: false },
];

const GmailComponent = ({
  emails,
  selected,
  setSelected,
  filter,
  setFilter,
}) => {
  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('address');
  const [modelData, setModelData] = useState(null);

  const handleClick = (event, id) => {
    const selectedIndex = selected.indexOf(id);
    let newSelected = [];
    if (selectedIndex === -1) {
      newSelected = newSelected.concat(selected, id);
    } else if (selectedIndex === 0) {
      newSelected = newSelected.concat(selected.slice(1));
    } else if (selectedIndex === selected.length - 1) {
      newSelected = newSelected.concat(selected.slice(0, -1));
    } else if (selectedIndex > 0) {
      newSelected = newSelected.concat(
        selected.slice(0, selectedIndex),
        selected.slice(selectedIndex + 1)
      );
    }
    setSelected(newSelected);
  };

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = emails.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });
    return stabilizedThis.map((el) => el[0]);
  }

  const isDataAvailable = () => {
    if (modelData !== null) {
      return true;
    } else {
      return false;
    }
  };

  const handleClose = () => setModelData(null);

  const filterEmailsList = applySortFilter(
    emails,
    getComparator(order, orderBy),
    filter
  );

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[2].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };

  const isUserNotFound = emails.length === 0;
  return (
    <>
      <UcListToolbar
        onSort={sortAll}
        placeholder='Search...'
        numSelected={selected.length}
        onFilter={(value) => setFilter(value)}
      />
      <Scrollbar>
        <TableContainer sx={{ minWidth: 800 }}>
          <Table>
            <UcListHead
              order={order}
              orderBy={orderBy}
              headLabel={TABLE_HEAD}
              rowCount={emails.length}
              numSelected={selected.length}
              onRequestSort={handleRequestSort}
              onSelectAllClick={handleSelectAllClick}
            />

            <TableBody>
              {filterEmailsList.map((row) => {
                const { id, message, sender, subject, date_time } = row;
                const isItemSelected = selected.indexOf(id) !== -1;

                return (
                  <TableRow
                    hover
                    key={id}
                    tabIndex={-1}
                    role='checkbox'
                    selected={isItemSelected}
                    aria-checked={isItemSelected}
                  >
                    <TableCell component='th' scope='row' padding='normal'>
                      <Stack direction='row' alignItems='center' spacing={2}>
                        <Typography variant='subtitle2' noWrap>
                          <Button
                            onClick={() => {
                              setModelData(row);
                            }}
                          >
                            View
                          </Button>
                        </Typography>
                      </Stack>
                    </TableCell>

                    <AlignedTableCell flow='left'>
                      <Typography variant='subtitle2' noWrap>
                        <Iconify icon='ant-design:user-outlined' />
                        From: {sender}
                      </Typography>
                      <Typography sx={{ pl: '20px' }} noWrap>
                        Subject: {subject}
                      </Typography>
                    </AlignedTableCell>
                    <AlignedTableCell flow='left'>
                      <Typography variant='subtitle2' noWrap>
                        <Iconify icon='system-uicons:calendar-date' />
                        {date_time}
                      </Typography>
                    </AlignedTableCell>
                  </TableRow>
                );
              })}
            </TableBody>
            {isUserNotFound && (
              <TableBody>
                <TableRow>
                  <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                    <SearchNotFound searchQuery={filter} />
                  </TableCell>
                </TableRow>
              </TableBody>
            )}
          </Table>
          {modelData ? (
            <Modal
              open={isDataAvailable()}
              onClose={handleClose}
              aria-labelledby='modal-modal-title'
              aria-describedby='modal-modal-description'
            >
              <Box
                component='div'
                xs={{
                  borderRadius: '15px',
                  position: 'absolute',
                  top: '50%',
                  padding: '3%',
                  left: '50%',
                  transform: 'translate(-50%, -50%)',
                  minWidth: '60%',
                  maxWidth: '80%',
                  height: '80%',
                  bgcolor: 'background.paper',
                }}
                md={{
                  borderRadius: '15px',
                  position: 'absolute',
                  top: '50%',
                  padding: '3%',
                  left: '50%',
                  transform: 'translate(-50%, -50%)',
                  minWidth: '60%',
                  maxWidth: '80%',
                  height: '80%',
                  bgcolor: 'background.paper',
                }}
                sx={{
                  borderRadius: '15px',
                  position: 'absolute',
                  top: '50%',
                  padding: '3%',
                  left: '50%',
                  transform: 'translate(-50%, -50%)',
                  minWidth: '60%',
                  maxWidth: '80%',
                  height: '80%',
                  bgcolor: 'background.paper',
                }}
              >
                <Scrollbar>
                  <Typography variant='subtitle2' noWrap>
                    <span
                      style={{ color: 'secondary.main', marginRight: '10px' }}
                    >
                      From:
                    </span>
                    {modelData.sender}
                  </Typography>

                  <Typography variant='subtitle2' mt={2} noWrap>
                    <span
                      style={{ color: 'secondary.main', marginRight: '10px' }}
                    >
                      Subject:
                    </span>{' '}
                    {modelData.subject}
                  </Typography>
                  <Typography variant='subtitle2' mt={2} noWrap>
                    <span
                      style={{ color: 'secondary.main', marginRight: '10px' }}
                    >
                      Date:
                    </span>{' '}
                    {modelData.date_time}
                  </Typography>

                  <Typography mt={2} variant='subtitle2'>
                    <span
                      style={{ color: 'secondary.main', marginRight: '10px' }}
                    >
                      Message:
                    </span>{' '}
                    {modelData.message}
                  </Typography>
                </Scrollbar>
              </Box>
            </Modal>
          ) : null}
        </TableContainer>
      </Scrollbar>
    </>
  );
};

export default GmailComponent;
