import React from "react";

import { Modal } from "@mui/material";

import GoogleMapReact from "google-map-react";
import LocationOnIcon from "@mui/icons-material/LocationOn";

const MapModel = ({ handleClose, isLanLongAvailable, LatLang, markers }) => {
  return (
    <Modal
      open={isLanLongAvailable()}
      onClose={handleClose}
      aria-labelledby="modal-modal-title"
      aria-describedby="modal-modal-description"
    >
      <div
        style={{
          marginTop: "10%",
          marginLeft: "10%",
          height: "60vh",
          width: "80%",
        }}
      >
        <GoogleMapReact
          bootstrapURLKeys={{ key: process.env.REACT_APP_GOOGLE_MAP_API_KEY }}
          defaultCenter={{
            lat: Number(LatLang.lat),
            lng: Number(LatLang.lang),
          }}
          defaultZoom={10}
        >
          <LocationOnIcon
            style={{ marginTop: "-34px", marginLeft: "-17px" }}
            lat={Number(LatLang.lat)}
            lng={Number(LatLang.lang)}
            fontSize="large"
            color="error"
          />
        </GoogleMapReact>
      </div>
    </Modal>
  );
};

export default MapModel;
