import { Modal } from "@mui/material";
import { Circle, GoogleMap, useJsApiLoader } from "@react-google-maps/api";
import React from "react";

const MapMpdleForGeo = ({ handleClose, isLanLongAvailable, lanLongRed }) => {
  const center = {
    lat: Number(lanLongRed.lat) || 40.64,
    lng: Number(lanLongRed.lang) || -73.96,
  };

  const { isLoaded } = useJsApiLoader({
    id: "google-map-script",
    googleMapsApiKey: process.env.REACT_APP_GOOGLE_MAP_API_KEY,
  });

  return (
    <>
      <Modal
        open={isLanLongAvailable()}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
      >
        {isLoaded ? (
          <GoogleMap
            mapContainerStyle={{
              margin: "5% auto auto auto",
              height: "80%",
              width: "80%",
            }}
            center={center}
            zoom={12}
          >
            <Circle
              center={{
                lat: parseFloat(lanLongRed.lat),
                lng: parseFloat(lanLongRed.lang),
              }}
              // required
              options={{
                strokeColor: "#FF0000",
                radius: lanLongRed.radius * 1000,
              }}
            />
          </GoogleMap>
        ) : (
          <div></div>
        )}
      </Modal>
    </>
  );
};


export default MapMpdleForGeo;
