import {
  Box,
  Checkbox,
  FormControlLabel,
  IconButton,
  Modal,
} from "@mui/material";
import React, { useState } from "react";
import { Delete, CloudDownload } from "@material-ui/icons";
import "./ImagesComponent.css";
import DateShower from "../DateComponent/DateRow";

const ImagesComponent = ({
  selected,
  setSeleted,
  Images,
  filter,
  downloadAction,
}) => {
  const [urlForModel, setUrl] = useState(null);

  const handleClose = () => setUrl(null);

  const isUrlAvailable = () => {
    if (urlForModel !== null) {
      return true;
    } else {
      return false;
    }
  };

  const selectId = (itemID) => {
    setSeleted((priv) => [...priv, itemID]);
  };
  const removeId = (itemID) => {
    setSeleted((priv) => priv.filter((item) => item !== itemID));
  };

  const isSelected = (ID) => {
    let list = selected.filter((item) => item === ID);
    return list.length === 0 ? false : true;
  };

  const isSelectedByDate = (Date) => {
    const IDs = Images.filter(
      (item) => item.time.substring(0, 10) === Date
    ).map((item) => item.id);

    const allAvailable = IDs.map((item) => isSelected(item)).reduce(
      (pri, cur) => pri && cur
    );
    return allAvailable;
  };

  const indeterminateByDate = (Date) => {
    const isAvailable = Images.filter(
      (item) => item.time.substring(0, 10) === Date
    ).map((item) => isSelected(item.id));

    const positiveAvailable = isAvailable.filter((item) => item === true);
    const NagitiveAvailable = isAvailable.filter((item) => item === false);

    const isAllSelected = positiveAvailable.length !== isAvailable.length;
    const isAllNotSelected = NagitiveAvailable.length === isAvailable.length;

    return !(isAllSelected === isAllNotSelected);
  };
  const selectByDate = (time) => {
    removeByDate(time);
    Images.filter((item) => item.time.substring(0, 10) === time).map((item) =>
      selectId(item.id)
    );
  };

  const removeByDate = (time) =>
    Images.filter((item) => item.time.substring(0, 10) === time).map((item) =>
      removeId(item.id)
    );

  // This function select all the images
  const AddAll = () => {
    setSeleted([]);
    Images.forEach((item) => selectId(item.id));
  };

  // This function disselect all the images
  const RemoveAll = () => setSeleted([]);

  return (
    <>
      {/* <FormControlLabel
        value="end"
        control={
          <Checkbox
            checked={Images.length > 0 && Images.length === selected.length}
            indeterminate={
              Images.length > 0 &&
              Images.length !== selected.length &&
              selected.length !== 0
            }
            onChange={(event) =>
              event.target.checked ? AddAll() : RemoveAll()
            }
            inputProps={{ "aria-label": "controlled" }}
          />
        }
        label="SelectAll"
        labelPlacement="end"
      /> */}

      {Images.map((item, index, array) => {
        return (
          <div key={item.id} style={{ display: "inline" }}>
            {index === 0 ||
              array[--index].time.substring(0, 10) !==
              item.time.substring(0, 10) ? (
              <DateShower
                date={item.time.substring(0, 10)}
                select={selectByDate}
                remove={removeByDate}
                isSelected={isSelectedByDate}
                indeterminate={indeterminateByDate}
              />
            ) : null}
            <Image
              item={item}
              downloadAciton={downloadAction}
              select={selectId}
              remove={removeId}
              isSelected={isSelected}
              setUrlToModel={(url) => setUrl(url)}
            />
          </div>
        );
      })}

      <Modal
        open={isUrlAvailable()}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
      >
        <Box
          component="img"
          sx={{
            position: "absolute",
            top: "50%",
            left: "50%",
            transform: "translate(-50%, -50%)",
            maxWidth: '80%',
            height: "100%"
            , bgcolor: "background.paper",
          }}
          alt="image."
          src={urlForModel}
        />
      </Modal>
    </>
  );
};

export const Image = ({
  item,
  downloadAciton,
  select,
  remove,
  isSelected,
  setUrlToModel,
}) => {
  return (
    <div className="SingleImage">
      <Box
        component="img"
        className="image"
        onClick={() => setUrlToModel(item.src)}
        sx={{
          margin: "auto",
          height: 200,
          maxWidth: { xs: 300, md: 300 },
          maxHeight: { xs: 230, md: 230 },
          cursor: "pointer",
        }}
        alt="Image"
        src={item.src}
      />
      <div
        style={{
          display: "flex",
          justifyContent: "space-between",
          alignItems: "center",
        }}
      >
        <div>
          {/* <Checkbox
            checked={isSelected(item.id)}
            onChange={(event) =>
              event.target.checked ? select(item.id) : remove(item.id)
            }
            inputProps={{ "aria-label": "controlled" }}
          /> */}
          {/* <Link to={item.src} target="blank" >download</Link> */}
          <IconButton onClick={() => downloadAciton(item.src)}>
            <CloudDownload />
          </IconButton>
        </div>
        <p>{item.time.substring(10)}</p>
      </div>
    </div>
  );
};

import { saveAs } from "file-saver";
import { Link } from "react-router-dom";

const Index = ({ url }) => {
  const downloadImage = () => {
    saveAs(url, "image.jpg"); // Put your image url here.
  };

  return <button onClick={downloadImage}>Download!</button>;
};

export default ImagesComponent;
