import {
  Checkbox,
  Stack,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TablePagination,
  TableRow,
  Typography,
} from '@mui/material';
import da from 'date-fns/esm/locale/da/index.js';
import React, { useEffect, useState } from 'react';
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from 'src/sections/@dashboard/utilityComponents';
import Iconify from '../Iconify';
import Scrollbar from '../Scrollbar';
import SearchNotFound from '../SearchNotFound';

import useDeviceId from '../../hooks/useDeviceId';
import axios from 'axios';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';
import MuiIcon from 'src/sections/@dashboard/utilityComponents/MuiIcon';

const TABLE_HEAD = [
  { id: 'id', label: 'ID', alignRight: false },
  { id: 'keyword', label: 'KEYWORD', alignRight: false },
];

const AdminKeywords = ({ translate, updated }) => {
  const [selected, setSelected] = useState([]);
  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('Keyword');
  const [SearchedKeyWords, setSearchedKeywords] = useState([]);
  const [totalRows, setTotalrows] = useState(0);
  const [filter, setFilter] = useState('');
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const { deviceID, setDeviceID } = useDeviceId();

  useEffect(async () => {
    try {
      const result = await axios.get(`keyword-list/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });

      setSearchedKeywords(result.data.data.key_data);
      setTotalrows(result.data.data.total_count);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, filter, deviceID, updated]);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = SearchedKeyWords.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };
  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const isUserNotFound = SearchedKeyWords.length === 0;
  const handleClick = (event, id) => {
    const selectedIndex = selected.indexOf(id);
    let newSelected = [];
    if (selectedIndex === -1) {
      newSelected = newSelected.concat(selected, id);
    } else if (selectedIndex === 0) {
      newSelected = newSelected.concat(selected.slice(1));
    } else if (selectedIndex === selected.length - 1) {
      newSelected = newSelected.concat(selected.slice(0, -1));
    } else if (selectedIndex > 0) {
      newSelected = newSelected.concat(
        selected.slice(0, selectedIndex),
        selected.slice(selectedIndex + 1)
      );
    }
    setSelected(newSelected);
  };
  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[1].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };
  const filterList = (value) => {
    setPage(0);
    setFilter(value);
  };

  const FilterSearchedKeyWords = applySortFilter(
    SearchedKeyWords,
    getComparator(order, orderBy),
    filter
  );

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }
  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }

  return (
    <>
      <UcListToolbar
        onSort={sortAll}
        placeholder='Search By Keyword...'
        numSelected={selected.length}
        onFilter={filterList}
      />

      <Scrollbar>
        <TableContainer sx={{ minWidth: 800 }}>
          <Table>
            <UcListHead
              order={order}
              orderBy={orderBy}
              headLabel={TABLE_HEAD}
              rowCount={SearchedKeyWords.length}
              numSelected={selected.length}
              onRequestSort={handleRequestSort}
              onSelectAllClick={handleSelectAllClick}
            />
            <TableBody>
              {FilterSearchedKeyWords.map((row) => {
                const { id, keyword } = row;
                const isItemSelected = selected.indexOf(id) !== -1;

                return (
                  <TableRow
                    hover
                    key={id}
                    tabIndex={-1}
                    role='checkbox'
                    selected={isItemSelected}
                    aria-checked={isItemSelected}
                  >
                    <AlignedTableCell flow='left'>{id}</AlignedTableCell>

                    <TableCell component='th' scope='row' padding='none'>
                      <Stack direction='row' alignItems='center' spacing={2}>
                        <Typography variant='subtitle2' noWrap>
                          <MuiIcon icon='eva:people-fill' />
                          {keyword}
                        </Typography>
                      </Stack>
                    </TableCell>
                  </TableRow>
                );
              })}
            </TableBody>
            {isUserNotFound && (
              <TableBody>
                <TableRow>
                  <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                    <SearchNotFound searchQuery={filter} />
                  </TableCell>
                </TableRow>
              </TableBody>
            )}
          </Table>
        </TableContainer>
      </Scrollbar>
      <MyTablePagination
        count={totalRows}
        rowsPerPage={rowsPerPage}
        page={page}
        setPage={setPage}
        setRowsPerPage={setRowsPerPage}
      />
    </>
  );
};

export default AdminKeywords;
