import { useState } from 'react';
import PropTypes from 'prop-types';
import {
  NavLink as RouterLink,
  matchPath,
  useLocation,
  useNavigate,
} from 'react-router-dom';
// material
import { alpha, useTheme, styled } from '@mui/material/styles';
import {
  Box,
  List,
  Collapse,
  ListItemText,
  ListItemIcon,
  ListItemButton,
} from '@mui/material';
//
import Iconify from './Iconify';
import useLanguage from '../hooks/useLanguage';
import React from 'react';
import useDeviceId from '../hooks/useDeviceId'

// ----------------------------------------------------------------------

const ListItemStyle = styled((props) => (
  <ListItemButton disableGutters {...props} />
))(({ theme }) => ({
  ...theme.typography.body2,
  height: 48,
  position: 'relative',
  textTransform: 'capitalize',
  paddingLeft: theme.spacing(5),
  paddingRight: theme.spacing(2.5),
  color: theme.palette.text.secondary,
  '&:before': {
    top: 0,
    right: 0,
    width: 3,
    bottom: 0,
    content: "''",
    display: 'none',
    position: 'absolute',
    borderTopLeftRadius: 4,
    borderBottomLeftRadius: 4,
    backgroundColor: theme.palette.primary.main,
  },
}));

const ListItemIconStyle = styled(ListItemIcon)({
  width: 22,
  height: 22,
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
});

// ----------------------------------------------------------------------

NavItem.propTypes = {
  item: PropTypes.object,
  active: PropTypes.func,
};

function NavItem({ item, active }) {
  const theme = useTheme();
  const isActiveRoot = active(item.path);
  const { translate } = useLanguage();
  const {deviceID,setDeviceID} = useDeviceId();
  const Navigate =useNavigate();

  const { name, path, icon, info, children } = item;

  const [open, setOpen] = useState(isActiveRoot);

  const handleOpen = () => {
    setOpen((prev) => !prev);
  };

  const activeRootStyle = {
    color: 'secondary.main',
    fontWeight: 'fontWeightMedium',
    bgcolor: alpha(theme.palette.primary.main, 0.5),
    '&:before': { display: 'block', backgroundColor: 'secondary.main' },
  };

  const activeSubStyle = {
    color: 'text.primary',
    fontWeight: 'fontWeightMedium',
  };

  if (children) {
    return (
      <>
        <ListItemStyle
          onClick={handleOpen}
          sx={{
            ...(isActiveRoot && activeRootStyle),
          }}
        >
          <ListItemIconStyle>{icon&&<Iconify icon={icon} width={22} height={22} />}</ListItemIconStyle>
          <ListItemText disableTypography primary={translate(name)} />
          {info && info}
          <Iconify
            icon={
              open
                ? 'eva:arrow-ios-downward-fill'
                : 'eva:arrow-ios-forward-fill'
            }
            sx={{ width: 16, height: 16, ml: 1 }}
          />
        </ListItemStyle>

        <Collapse in={open} timeout='auto' unmountOnExit>
          <List component='div' disablePadding>
            {children.map((item) => {
              const { name, path } = item;
              const isActiveSub = active(path);

              return (
                <ListItemStyle
                  key={translate(name)}
                  component={RouterLink}
                  to={deviceID?path.startsWith("/dashboard/user-devices")?path:path+`/`+deviceID:path}
                  sx={{
                    ...(isActiveSub && activeSubStyle),
                  }}
                >
                  <ListItemIconStyle>
                    <Box
                      component='span'
                      sx={{
                        width: 4,
                        height: 4,
                        display: 'flex',
                        borderRadius: '50%',
                        alignItems: 'center',
                        justifyContent: 'center',
                        bgcolor: 'text.disabled',
                        transition: (theme) =>
                          theme.transitions.create('transform'),
                        ...(isActiveSub && {
                          transform: 'scale(2)',
                          bgcolor: 'primary.main',
                        }),
                      }}
                    />
                  </ListItemIconStyle>
                  <ListItemText disableTypography primary={translate(name)} />
                </ListItemStyle>
              );
            })}
          </List>
        </Collapse>
      </>
    );
  }

  return (
    <ListItemStyle
      onClick={()=>{
        if(path.startsWith("/dashboard/user-devices")){
          setDeviceID(null);
        }
        Navigate(deviceID?path.startsWith("/dashboard/user-devices")?path:path+`/`+deviceID:path)
      }}
      sx={{
        ...(isActiveRoot && activeRootStyle),
      }}
    >
      <ListItemIconStyle>{icon&&<Iconify icon={icon} width={22} height={22} />}</ListItemIconStyle>
      <ListItemText disableTypography primary={translate(name)} />
      {info && info}
    </ListItemStyle>
  );
}

NavSection.propTypes = {
  navConfig: PropTypes.array,
};
export default function NavSection({ navConfig, ...other }) {
  const { pathname } = useLocation();
  const { language} = useLanguage();
  
  const match = (path) =>
    path ? !!matchPath({ path, end: false }, pathname) : false;

  return (
    <Box {...other} dir={language.flow === 'RTL' ? 'rtl' : 'ltr'}>
      <List disablePadding>

        {navConfig.map((item) => (
          <NavItem key={item.name} item={item} active={match} />
        ))}
        
      </List>
    </Box>
  );
}
