import {
  Button,
  Box,
  FormControl,
  InputLabel,
  Select,
  MenuItem,
  Modal,
  Card,
  Checkbox,
  FormControlLabel,
  Grid,
} from "@mui/material";
import React, { useEffect, useState } from "react";
import TextField from "@mui/material/TextField";
import DialogActions from "@mui/material/DialogActions";
import DialogContent from "@mui/material/DialogContent";
import DialogContentText from "@mui/material/DialogContentText";
import DialogTitle from "@mui/material/DialogTitle";
import axios from "axios";
import Scrollbar from "./Scrollbar";

const RoleDilog = ({ open, handleClose, update, defaultData, features }) => {
  const [formData, setFormData] = useState(defaultData);

  const [isError, setError] = useState(false);

  let featuresList = update ? features : [];

  const handleSubmit = async () => {
    try {
      if (!formData.name || !formData.description) {
        setError(true);
        return;
      }

      await axios.post(
        update ? `admin/role-update/${formData.id}` : `admin/role-store`,
        formData.permission
          ? { ...formData, permission: formData.permission.toString() }
          : formData
      );

      handleClose(true);
    } catch (error) {
      console.log(error);
      handleClose();
    }
  };
  console.log(defaultData, "form", formData);

  return (
    <Modal
      open={open}
      onClose={handleClose}
      aria-labelledby="modal-modal-title"
      aria-describedby="modal-modal-description"
      sx={{height:"100%",overflowY:'scroll'}}
    >
      <Card sx={{ width: "70%", margin: "auto" }}>
        <Box
          className="FormLayout"
          sx={{
            width: "100%",
            margin: "auto",
          }}
        >
          <Box>
            <Scrollbar>
              <DialogTitle>
                {update ? "Update Role" : "Create Role"}
              </DialogTitle>

              <DialogContent>
                {isError ? (
                  <DialogContentText color="red">
                    All Fields Must Be Field.
                  </DialogContentText>
                ) : null}

                <Grid container spacing={2}>
                  <Grid item xs={6}>
                    <TextField
                      fullWidth
                      autoFocus
                      margin="dense"
                      disabled={update}
                      id="name"
                      variant="outlined"
                      value={formData.name}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          name: e.target.value,
                        }))
                      }
                      aria-errormessage="heklki"
                      label="Name"
                      type="text"
                    />
                  </Grid>
                  <Grid item xs={6}>
                    <TextField
                      fullWidth
                      margin="dense"
                      id="description"
                      variant="outlined"
                      label="Description"
                      value={formData.description}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          description: e.target.value,
                        }))
                      }
                      type="text"
                    />
                  </Grid>
                </Grid>
                <Grid container spacing={1} sx={{ padding: "10px" }}>
                  {featuresList.map((item) => {
                    return (
                      <Grid item xs={3}>
                        <FormControlLabel
                          control={
                            <Checkbox
                              size="small"
                              defaultChecked={formData.permission?.includes(
                                item.id
                              )}
                              onChange={(e) => {
                                if (e.target.checked) {
                                  if (formData.permission) {
                                    setFormData((pri) => ({
                                      ...pri,
                                      permission: [
                                        ...formData.permission,
                                        item.id,
                                      ],
                                    }));
                                  } else {
                                    setFormData((pri) => ({
                                      ...pri,
                                      permission: [item.id],
                                    }));
                                  }
                                } else {
                                  const index = formData.permission.indexOf(
                                    item.id
                                  );
                                  if (index !== -1) {
                                    formData.permission.splice(index, 1);
                                    setFormData((pri) => ({
                                      ...pri,
                                      permission: formData.permission,
                                    }));
                                  }
                                }
                              }}
                            />
                          }
                          label={item.name}
                        />
                      </Grid>
                    );
                  })}
                </Grid>

                <DialogActions>
                  <Button
                    onClick={() => {
                      handleClose();
                    }}
                  >
                    Cancel
                  </Button>
                  <Button onClick={handleSubmit}>
                    {update ? "update" : "Add New"}
                  </Button>
                </DialogActions>
              </DialogContent>
            </Scrollbar>
          </Box>
        </Box>
      </Card>
    </Modal>
  );
};

export default RoleDilog;
