import { CloudDownload, Delete } from "@material-ui/icons";
import {
  Box,
  Checkbox,
  FormControlLabel,
  IconButton,
  Modal,
  TextField,
} from "@mui/material";
import React, { useState } from "react";
import { UcListToolbar } from "src/sections/@dashboard/utilityComponents";
import DateShower from "../DateComponent/DateRow";
import "./Videos.css";

import PlayCircleIcon from "@mui/icons-material/PlayCircle";

const Videos = ({
  selected,
  setSeleted,
  VideosList,
  filter,
  downloadAction,
}) => {
  const [urlForModel, setUrl] = useState(null);

  const handleClose = () => setUrl(null);

  const isUrlAvailable = () => {
    if (urlForModel !== null) {
      return true;
    } else {
      return false;
    }
  };

  const selectByDate = (time) => {
    removeByDate(time);
    VideosList.filter((item) => item.time.substring(0, 10) === time).map(
      (item) => selectId(item.id)
    );
  };

  const removeByDate = (time) => {
    VideosList.filter((item) => item.time.substring(0, 10) === time).map(
      (item) => removeId(item.id)
    );
  };

  // This function select all the images
  const AddAll = () => {
    setSeleted([]);
    VideosList.forEach((item) => selectId(item.id));
  };

  // This function disselect all the images
  const RemoveAll = () => setSeleted([]);

  const selectId = (itemID) => {
    setSeleted((priv) => [...priv, itemID]);
  };
  const removeId = (itemID) => {
    setSeleted((priv) => priv.filter((item) => item !== itemID));
  };

  const isSelected = (ID) => {
    let list = selected.filter((item) => item === ID);
    return list.length === 0 ? false : true;
  };

  const isSelectedByDate = (Date) => {
    const IDs = VideosList.filter(
      (item) => item.time.substring(0, 10) === Date
    ).map((item) => item.id);

    const allAvailable = IDs.map((item) => isSelected(item)).reduce(
      (pri, cur) => pri && cur
    );
    return allAvailable;
  };
  const indeterminateByDate = (Date) => {
    const isAvailable = VideosList.filter(
      (item) => item.time.substring(0, 10) === Date
    ).map((item) => isSelected(item.id));

    const positiveAvailable = isAvailable.filter((item) => item === true);
    const NagitiveAvailable = isAvailable.filter((item) => item === false);

    const isAllSelected = positiveAvailable.length !== isAvailable.length;
    const isAllNotSelected = NagitiveAvailable.length === isAvailable.length;

    return !(isAllSelected === isAllNotSelected);
  };
  return (
    <>
      {/* <UcListToolbar numSelected={selected.length} onFilterName={filter} /> */}

      {/* <FormControlLabel
        value="end"
        control={
          <Checkbox
            checked={
              VideosList.length > 0 && VideosList.length === selected.length
            }
            indeterminate={
              VideosList.length > 0 &&
              VideosList.length !== selected.length &&
              selected.length !== 0
            }
            onChange={(event) =>
              event.target.checked ? AddAll() : RemoveAll()
            }
            inputProps={{ "aria-label": "controlled" }}
          />
        }
        label="SelectAll"
        labelPlacement="end"
      /> */}
      {VideosList.map((item, index, array) => {
        return (
          <div key={item.id} style={{ display: "inline" }}>
            {index === 0 ||
              array[--index].time.substring(0, 10) !==
              item.time.substring(0, 10) ? (
              <DateShower
                date={item.time.substring(0, 10)}
                select={selectByDate}
                remove={removeByDate}
                isSelected={isSelectedByDate}
                indeterminate={indeterminateByDate}
              />
            ) : null}
            <Video
              item={item}
              downloadAciton={downloadAction}
              select={selectId}
              remove={removeId}
              isSelected={isSelected}
              setUrlToModel={(url) => setUrl(url)}
            />
          </div>
        );
      })}
      <Modal
        open={isUrlAvailable()}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
      >
        <Box
          component="video"
          controls
          autoPlay
          sx={{
            position: "absolute",
            top: "50%",
            left: "50%",
            transform: "translate(-50%, -50%)",

            maxWidth: '80%',
            height: "100%",
          }}
          alt="Video."
          src={urlForModel}
        />
      </Modal>
    </>
  );
};

export const Video = ({
  item,
  select,
  remove,
  isSelected,
  downloadAciton,
  setUrlToModel,
}) => {
  return (
    <div className="videoHolder">
      <Box
        component="video"
        className="Video"
        // onMouseOver={(event) => event.target.play()}
        // onMouseOut={(event) => {
        //   event.target.currentTime = 1;
        //   event.target.pause();
        // }}
        onClick={() => setUrlToModel(item.src)}
        muted="muted"
        sx={{
          height: "100%",
          width: "100%",
          maxHeight: { xs: 233, md: 167 },
          maxWidth: { xs: 350, md: 250 },
          cursor: "pointer",
        }}
        alt="video"
        src={`${item.src}#t=1`}
      />


      <div
        style={{
          display: "flex",
          justifyContent: "space-between",
          alignItems: "center",
        }}
      >
        <div>
          {/* <Checkbox
            checked={isSelected(item.id)}
            onChange={(event) =>
              event.target.checked ? select(item.id) : remove(item.id)
            }
            inputProps={{ "aria-label": "controlled" }}
          /> */}

          <IconButton onClick={() => downloadAciton(item.src)}>
            <CloudDownload />
          </IconButton>
        </div>
        <p>{item.time.substring(10)}</p>
      </div>
    </div>
  );
};

export default Videos;
