import React, { useState } from 'react';
import './audio.css';
import AudioPlayer from '../CustomAudioPlayer/AudioPlayer';
import 'react-h5-audio-player/lib/styles.css';
import { Checkbox, IconButton } from '@mui/material';
import DateShower from '../DateComponent/DateRow';
import { CloudDownload, Delete } from '@material-ui/icons';

const Audio = ({ selected, setSeleted, Audios, filter, downloadAction }) => {
  const [runingSong, setRuningSong] = useState('');

  const selectId = (itemID) => {
    setSeleted((priv) => [...priv, itemID]);
  };
  const removeId = (itemID) => {
    setSeleted((priv) => priv.filter((item) => item !== itemID));
  };

  const isSelected = (ID) => {
    let list = selected.filter((item) => item === ID);
    return list.length === 0 ? false : true;
  };

  const isSelectedByDate = (Date) => {
    const IDs = Audios.filter(
      (item) => item.time.substring(0, 10) === Date
    ).map((item) => item.id);

    const allAvailable = IDs.map((item) => isSelected(item)).reduce(
      (pri, cur) => pri && cur
    );
    return allAvailable;
  };

  const indeterminateByDate = (Date) => {
    const isAvailable = Audios.filter(
      (item) => item.time.substring(0, 10) === Date
    ).map((item) => isSelected(item.id));

    const positiveAvailable = isAvailable.filter((item) => item === true);
    const NagitiveAvailable = isAvailable.filter((item) => item === false);

    const isAllSelected = positiveAvailable.length !== isAvailable.length;
    const isAllNotSelected = NagitiveAvailable.length === isAvailable.length;

    return !(isAllSelected === isAllNotSelected);
  };

  const selectByDate = (time) => {
    removeByDate(time);
    Audios.filter((item) => item.time.substring(0, 10) === time).map((item) =>
      selectId(item.id)
    );
  };

  const removeByDate = (time) =>
    Audios.filter((item) => item.time.substring(0, 10) === time).map((item) =>
      removeId(item.id)
    );

  return (
    <>
      {Audios.map((item, index, array) => {
        return (
          <div key={item.id} style={{ display: 'inline' }}>
            {index === 0 ||
              array[--index].time.substring(0, 10) !==
              item.time.substring(0, 10) ? (
              <DateShower
                date={item.time.substring(0, 10)}
                select={selectByDate}
                remove={removeByDate}
                isSelected={isSelectedByDate}
                indeterminate={indeterminateByDate}
              />
            ) : null}
            <AudioCard
              item={item}
              downloadAciton={downloadAction}
              select={selectId}
              remove={removeId}
              isSelected={isSelected}
              setRuningSong={setRuningSong}
              runingSong={runingSong}
            />
          </div>
        );
      })}
    </>
  );
};

const AudioCard = ({
  item,
  downloadAciton,
  select,
  remove,
  isSelected,
  setRuningSong,
  runingSong,
}) => {
  return (
    <div className='AudioCard'>
      <AudioPlayer
        item={item}
        setRuningSong={setRuningSong}
        runingSong={runingSong}
      />

      <div
        style={{
          display: 'flex',
          justifyContent: 'space-between',
          alignItems: 'center',
        }}
      >
        <div>
          <Checkbox
            checked={isSelected(item.id)}
            onChange={(event) =>
              event.target.checked ? select(item.id) : remove(item.id)
            }
            inputProps={{ 'aria-label': 'controlled' }}
          />
          <IconButton onClick={() => downloadAciton(item.src)}>
            <CloudDownload />
          </IconButton>
        </div>
        <p>{item.time.substring(10)}</p>
      </div>
    </div>
  );
};

export default Audio;
