import axios from "axios";
import React, { useState, createContext, useEffect } from "react";


const DeviceContext = createContext();

const useDeviceId = () => {
  const [deviceID, setDevice] = useState(null);
  const [deviceList, setDeviceList] = useState([]);
  const [loadAgain, setLoadagain] = useState(0);

  

  useEffect(async () => {
    try {
      const result = await axios.get("devices");
      if (result.data.data) {
        console.log(result)
        setDeviceList(result.data.data);
        console.log(result);
      }
    } catch (error) {
      console.log(error);
    }
  }, [loadAgain]);

  return {
    deviceID,
    setDeviceID: (id) => {
      setDevice(id);
    },
    deviceList,
    setLoadagain,
  };
};

export const DeviceProvider = ({ children }) => {
  const auth = useDeviceId();
  return (
    <DeviceContext.Provider value={auth}>{children}</DeviceContext.Provider>
  );
};

const DeviceConsumer = () => {
  return React.useContext(DeviceContext);
};
export default DeviceConsumer;
