import React, { useState, createContext } from "react";
import languages from "../../src/languages.json";
const LanguageContext = createContext();

const uselanguage = () => {
  const [language, setLang] = useState({ value: "en", flow: "LTR" });
  const [mode, setMode] = useState("Dark");

  let lang = window.localStorage.getItem("language");

  if (lang) {
    if (language && language.value !== JSON.parse(lang).value) {
      setLang(JSON.parse(lang));
    }
  }

  let localmode = window.localStorage.getItem("mode");
  if (localmode) {
    if (mode && mode !== localmode) {
      setMode(localmode);
    }
  }

  return {
    language,
    mode,
    setMode: (NewMode) => {
      setMode(NewMode);
      window.localStorage.setItem("mode", NewMode);
    },
    setLanguage: (lang) => {
      setLang(lang);
      window.localStorage.setItem("language", JSON.stringify(lang));
    },
    translate: (word) => {
      let isExists = !!languages[word];
      if (isExists) {
        return languages[word][language.value]
          ? languages[word][language.value]
          : word;
      } else {
        return word;
      }
    },
  };
};

export const LanguageProvider = ({ children }) => {
  const langugae = uselanguage();
  return (
    <LanguageContext.Provider value={langugae}>
      {children}
    </LanguageContext.Provider>
  );
};

const LanguageConsumer = () => {
  return React.useContext(LanguageContext);
};
export default LanguageConsumer;
