import React from "react";

import { useEffect, useState } from "react";
// material
import {
  Card,
  Table,
  Stack,
  Avatar,
  Checkbox,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  TablePagination,
  IconButton,
} from "@mui/material";
// components
import Page from "../components/Page";
import Scrollbar from "../components/Scrollbar";
import SearchNotFound from "../components/SearchNotFound";
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from "../sections/@dashboard/utilityComponents";
//
import axios from "axios";

import useDeviceId from "../hooks/useDeviceId";

import useLanguage from "../hooks/useLanguage";
import MyTablePagination from "src/sections/@dashboard/utilityComponents/MyTablePagination";
import AlignedTableCell from "src/sections/@dashboard/utilityComponents/AlignedTableCell";
import MuiIcon from "src/sections/@dashboard/utilityComponents/MuiIcon";
// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: "id", label: "ID", alignRight: false },

  { id: "application_name", label: "NAME", alignRight: false },
  { id: "application_package_name", label: "PACKAGE NAME", alignRight: false },
  { id: "application_time_usage", label: "USAGE TIME", alignRight: false },
  { id: "date_time", label: "DATE & TIME", alignRight: false },
];

// ----------------------------------------------------------------------

function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === "desc"
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}

function applySortFilter(array, comparator, query) {
  const stabilizedThis = array.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) return order;
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}

export default function ApplicationActivity() {
  const [page, setPage] = useState(0);
  const [order, setOrder] = useState("asc");
  const [orderBy, setOrderBy] = useState("name");
  const [appsActivityList, setappsActivityList] = useState([]);

  const [totalrows, settotalrows] = useState(0);
  const [selected, setSelected] = useState([]);
  const [filter, setFilter] = useState("");
  const [rowsPerPage, setRowsPerPage] = useState(5);

  const { deviceID, setDeviceID } = useDeviceId();
  const translate = useLanguage().translate;

  useEffect(async () => {
    try {
      const result = await axios.get(`applications/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      console.log(result);
      settotalrows(result.data.data.total_count);
      setappsActivityList(result.data.data.application_data);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filter]);

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[0].id;
    const isAsc = orderBy === sortId && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(sortId);
  };

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = appsActivityList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  const handleFilter = (value) => {
    setFilter(value);
  };

  const filteredAppBlock = applySortFilter(
    appsActivityList,
    getComparator(order, orderBy),
    filter
  );

  const reload = async () => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "APPLICATIONS",
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };

  const isAppBlockNotFound = filteredAppBlock.length === 0;
  return (
    <Page title={translate("Applications Activities")}>
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            {translate("Applications Activities")}
            <IconButton onClick={reload}>
              <MuiIcon icon="pepicons:reload" width="25px" height="25px" />
            </IconButton>
          </Typography>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder="Search By Name..."
            numSelected={selected.length}
            onFilter={handleFilter}
          />

          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={appsActivityList.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {filteredAppBlock.map((row) => {
                    const {
                      id,
                      application_name,
                      application_package_name,
                      date_time,
                      application_time_usage,
                      application_logo,
                      action,
                    } = row;
                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role="checkbox"
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        <AlignedTableCell flow="left">
                          {id}
                        </AlignedTableCell>
                        <TableCell component="th" scope="row" padding="normal">
                          <Stack
                            direction="row"
                            alignItems="center"
                            spacing={2}
                          >
                            <Avatar
                              alt={application_name}
                              src={application_logo}
                            />
                            <Typography variant="subtitle2" noWrap>
                              {application_name}
                            </Typography>
                          </Stack>
                        </TableCell>

                        <AlignedTableCell flow="left">
                          {application_package_name}
                        </AlignedTableCell>

                        <AlignedTableCell flow="left">
                          {application_time_usage}
                        </AlignedTableCell>
                        <AlignedTableCell flow="left">
                          {date_time}
                        </AlignedTableCell>
                      </TableRow>
                    );
                  })}
                </TableBody>
                {isAppBlockNotFound && (
                  <TableBody>
                    <TableRow>
                      <TableCell align="center" colSpan={6} sx={{ py: 3 }}>
                        <SearchNotFound searchQuery={filter} />
                      </TableCell>
                    </TableRow>
                  </TableBody>
                )}
              </Table>
            </TableContainer>
          </Scrollbar>

          <MyTablePagination
            count={totalrows}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
}
