import {
  Accordion,
  AccordionDetails,
  AccordionSummary,
  Box,
  Container,
  Grid,
  TextField,
  Typography,
} from '@mui/material';
import React, { useEffect, useState } from 'react';
import { useParams } from 'react-router-dom';
import Page from 'src/components/Page';
import StripeCheckOut from '../components/Checkout/StripeCheckOut';
import axios from 'axios';
import { styled } from '@mui/material/styles';
import PayPalCheckOut from 'src/components/Checkout/PayPalCheckOut';
import CoinbaseCommerceButton from 'react-coinbase-commerce';
import 'react-coinbase-commerce/dist/coinbase-commerce-button.css';
import { useNavigate } from 'react-router-dom';


const ContentStyle = styled('div')(({ theme }) => ({
  margin: 'auto',
  display: 'flex',
  minHeight: '100vh',
  flexDirection: 'column',
  justifyContent: 'center',
  padding: theme.spacing(12, 0),
}));

const RootStyle = styled(Page)(({ theme }) => ({
  [theme.breakpoints.up('md')]: {
    display: 'flex',
  },
}));

const defaultFormsValues = {
  name: { value: '', error: '' },
  Email: { value: '', error: '' },
  Adress: { value: '', error: '' },
  City: { value: '', error: '' },
  State: { value: '', error: '' },
  Country: { value: '', error: '' },
  Phone: { value: '', error: '' },
};

const StripeTestPage = () => {
  const { PlanID, deviceId } = useParams();

  const Navigate = useNavigate();
  const [planInfo, setPlanInfo] = useState({});
  const [formData, setFormData] = useState(defaultFormsValues);

  // hare i'm sending all the data after payment to server
  const sumbitDetails = async (detailsORtocken, method) => {
    try {
      console.log(method, detailsORtocken);
      let body = {
        PlanID,
        userDetails: {
          name: formData.name.value,
          Email: formData.Email.value,
          Adress: formData.Adress.value,
          City: formData.City.value,
          State: formData.State.value,
          Country: formData.Country.value,
          Phone: formData.Phone.value,
        },
        source: method,
      };

      if (method === 'STRIPE') {

        body.token = detailsORtocken;
      }

      if (method === 'PAYPAL') {
        body.paymentDetails = detailsORtocken;
      }
      if (deviceId) {
        body.deviceId = deviceId;
      }

      const responce = await axios.post('payment-process', body);
      console.log(method + ' responce:', responce);
      if (responce.status === 200) {
        console.log('Show Congradulations Message');
        Navigate("/dashboard/user-devices");
      }
    } catch (error) {
      console.log("in PAyment function", error);
    }
  };

  useEffect(async () => {
    try {
      const result = await axios.get(`/plan/${PlanID}`);
      setPlanInfo(result.data.data[0]);
      console.log('planInfo: ', planInfo);
    } catch (error) {
      console.log(error);
    }
  }, []);

  const isFormCompleted = (() => {
    const isNameValid = !!(formData.name.value && !formData.name.error);
    const isEmailValid = !!(formData.Email.value && !formData.Email.error);
    const isAdressValid = !!(formData.Adress.value && !formData.Adress.error);
    const isCityValid = !!(formData.City.value && !formData.City.error);
    const isStateValid = !!(formData.State.value && !formData.State.error);
    const isCountryValid = !!(
      formData.Country.value && !formData.Country.error
    );
    const isPhoneValid = !!(formData.Phone.value && !formData.Phone.error);
    if (
      isNameValid &&
      isEmailValid &&
      isAdressValid &&
      isCityValid &&
      isStateValid &&
      isCountryValid &&
      isPhoneValid
    ) {
      return true;
    } else {
      return false;
    }
  })();

  const [expanded, setExpanded] = React.useState(false);

  const handleChange = (panel) => (event, isExpanded) => {
    setExpanded(isExpanded ? panel : false);
  };

  return (
    <RootStyle title='Check Out page'>
      <Container>

        <ContentStyle>
          <Box sx={{ display: { xs: 'inlineBlock', md: 'flex' }, justifyContent: 'space-between' }} >
            <Box sx={{ width: { xs: '100%', md: '50%' }, marginTop: { xs: '20px', md: '0px' }, marginRight: { xs: '0px', md: '20px' } }} >
              <Box sx={{ display: 'flex', textAlign: 'center', minHeight: "35px", marginBottom: '10px' }} >
                <Box sx={{ borderLeft: '3px solid', borderColor: 'primary.main', height: '30px', marginTop: "1%", textAlign: 'center' }}></Box>
                <Typography variant='h3' sx={{ marginLeft: '10px' }}  >Billing Information</Typography>
              </Box>
              <DetailsForm setFormData={setFormData} formData={formData} />
            </Box>
            <Box sx={{ width: { xs: '100%', md: '40%' }, marginTop: { xs: '20px', md: '0px' } }} >
              <ProductInfo planInfo={planInfo} />
              <Box sx={{ display: 'flex', textAlign: 'center', minHeight: "35px", marginBottom: '10px' }} >
                <Box sx={{ borderLeft: '3px solid', borderColor: 'primary.main', height: '30px', marginTop: "1%", textAlign: 'center' }}></Box>
                <Typography variant='h3' sx={{ marginLeft: '10px' }}  >Select A Payment Method</Typography>
              </Box>
              <Box
                component='div'
                sx={{
                  pointerEvents: [isFormCompleted ? 1 : 'none'],
                  opacity: [isFormCompleted ? 1 : 0.6],
                }}
              >
                <Accordion
                  sx={{ borderRadius: [expanded === 'stripe' && "10px"] }}
                  expanded={expanded === 'stripe'}
                  onChange={handleChange('stripe')}
                >
                  <Box sx={{ backgroundColor: [expanded === 'stripe' ? "primary.main" : "background.paper"], borderTopRightRadius: '10px', borderTopLeftRadius: '10px' }}
                  >

                    <AccordionSummary
                      aria-controls='panel1a-content'
                      id='panel1a-header'
                    >

                      <Typography sx={{ width: '33%', flexShrink: 0 }}>
                        Pay by Card
                      </Typography>
                      <Box sx={{ width: '67%', maxHeight: "30px", textAlign: 'right' }} >

                      <Box
                        sx={{display:'inline-block'}}
                        component="img"
                        alt="paypal logo"
                        src="/images/cards_logos.png"
                      />

                      </Box>
                    </AccordionSummary>
                  </Box>
                  <AccordionDetails>
                    <StripeCheckOut
                      amount={planInfo.cost_price}
                      sumbitDetails={sumbitDetails}
                      planId={planInfo.id}
                      details={{
                        name: formData.name.value,
                        Email: formData.Email.value,
                        Adress: formData.Adress.value,
                        City: formData.City.value,
                        State: formData.State.value,
                        Country: formData.Country.value,
                        Phone: formData.Phone.value,
                      }}
                    />
                  </AccordionDetails>
                </Accordion>

                <Accordion
                  sx={{ borderRadius: [expanded === 'paypal' && "10px"] }}
                  expanded={expanded === 'paypal'}
                  onChange={handleChange('paypal')}
                >
                  <Box sx={{ backgroundColor: [expanded === 'paypal' ? "primary.main" : "background.paper"], borderTopRightRadius: '10px', borderTopLeftRadius: '10px' }}
                  >
                    <AccordionSummary

                      aria-controls='panel1a-content'
                      id='panel1a-header'
                    >

                      <Typography sx={{ width: '33%', flexShrink: 0 }}>
                        Pay Pal
                      </Typography>
                      <Box sx={{ width: '67%', maxHeight: "30px", textAlign: 'right' }} >

                      <Box
                      sx={{display:'inline-block'}}
                        component="img"
                        alt="paypal logo "
                        src="/images/paypal_logo.png"
                      />
                      </Box>
                    </AccordionSummary>
                  </Box>

                  <AccordionDetails>
                    <PayPalCheckOut
                      cost_price={planInfo.cost_price}
                      sumbitDetails={sumbitDetails}
                    />
                  </AccordionDetails>
                </Accordion>

                {/* <Accordion
                  sx={{ borderRadius: [expanded === 'Cripto' && "10px"] }}
                  expanded={expanded === 'Cripto'}
                  onChange={handleChange('Cripto')}


                >
                  <Box sx={{ backgroundColor: [expanded === 'Cripto' ? "primary.main" : "background.paper"], borderTopRightRadius: '10px', borderTopLeftRadius: '10px' }}
                  >
                    <AccordionSummary
                      aria-controls='panel1a-content'
                      id='panel1a-header'
                    >
                      <Typography sx={{ width: '33%', flexShrink: 0 }}>
                        Cripto
                      </Typography>
                      <Box sx={{ width: '67%', maxHeight: "30px", textAlign: 'right' }} >

                        <Box
                          sx={{ display: 'inline-block' }}
                          component="img"
                          alt="paypal logo "
                          src="/spy/images/cripto_logo.png"
                        />
                      </Box>
                    </AccordionSummary>
                  </Box>

                  We need to create a charge to accept payment that will be from backend. it's like a payment intent
                  <AccordionDetails>
                      //https://github.com/coinbase/react-coinbase-commerce/blob/master/readme.md
                    <CoinbaseCommerceButton
                      styled
                      checkoutId={'c3f00f03-3f04-49b6-b0da-c7e8e238d2e3'}
                    />
                  </AccordionDetails>
                </Accordion> */}
              </Box>
            </Box>
          </Box>
        </ContentStyle>
      </Container>
    </RootStyle>
  );
};

const DetailsForm = ({ formData, setFormData }) => {
  // hare i'm runing validatators for form validationSchema
  (() => {
    // Phone Validations
    const PhoneRegex = /(\+\d{1,3}\s?)?((\(\d{3}\)\s?)|(\d{3})(\s|-?))(\d{3}(\s|-?))(\d{4})(\s?(([E|e]xt[:|.|]?)|x|X)(\s?\d+))?/g;

    const Phone = formData.Phone.value;

    const PhoneError = formData.Phone.error;

    if (!Phone && !PhoneError) {
    } else {
      if (Phone && !PhoneError && PhoneRegex.test(Phone) === false) {
        setFormData({
          ...formData,
          Phone: { value: Phone, error: 'Phone Number is not valid' },
        });
      }
      if (PhoneError && PhoneRegex.test(Phone) === true) {
        setFormData({
          ...formData,
          Phone: { value: Phone, error: '' },
        });
      }
    }

    // Email Validations
    const Emailregex =
      /^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;

    const email = formData.Email.value;

    const EmailError = formData.Email.error;

    if (!email && !EmailError) {
    } else {
      if (email && !EmailError && Emailregex.test(email) === false) {
        setFormData({
          ...formData,
          Email: { value: email, error: 'Email is not valid' },
        });
      }
      if (EmailError && Emailregex.test(email) === true) {
        setFormData({
          ...formData,
          Email: { value: email, error: '' },
        });
      }
    }
  })();

  return (
    <Box
      component='form'
      noValidate
      autoComplete='off'
    >
      <Grid container spacing={2}>
        <Grid item xs={12} sm={12} md={12}>
          <TextField
            required
            id='nameField'
            label='Name'
            variant='outlined'
            value={formData.name.value}
            onChange={(e) =>
              setFormData({
                ...formData,
                name: { value: e.target.value, error: '' },
              })
            }
            fullWidth
          />
        </Grid>
        <Grid item xs={12} sm={12} md={12}>
          <TextField
            required
            error={formData.Email.error}
            id='EmailField'
            label='Email'
            value={formData.Email.value}
            onChange={(e) =>
              setFormData({
                ...formData,
                Email: { value: e.target.value, error: '' },
              })
            }
            helperText={formData.Email.error}
            variant='outlined'
            fullWidth
          />
        </Grid>
        <Grid item xs={12} sm={12} md={12}>
          <TextField
            required
            id='AdressField'
            label='Address'
            onChange={(e) =>
              setFormData({
                ...formData,
                Adress: { value: e.target.value, error: '' },
              })
            }
            value={formData.Adress.value}
            variant='outlined'
            fullWidth
          />
        </Grid>

        <Grid item xs={12} sm={6} md={6}>
          <TextField
            required
            id='CityField'
            value={formData.City.value}
            label='City'
            onChange={(e) =>
              setFormData({
                ...formData,
                City: { value: e.target.value, error: '' },
              })
            }
            variant='outlined'
            fullWidth
          />
        </Grid>
        <Grid item xs={12} sm={6} md={6}>
          <TextField
            required
            id='CountryField'
            label='State'
            value={formData.State.value}
            onChange={(e) =>
              setFormData({
                ...formData,
                State: { value: e.target.value, error: '' },
              })
            }
            variant='outlined'
            fullWidth
          />
        </Grid>

        <Grid item xs={12} sm={12} md={12}>
          <TextField
            required
            id='CountryField'
            label='Country'
            variant='outlined'
            value={formData.Country.value}
            onChange={(e) =>
              setFormData({
                ...formData,
                Country: { value: e.target.value, error: '' },
              })
            }
            fullWidth
          />
        </Grid>
        <Grid item xs={12} sm={12} md={12}>
          <TextField
            required
            error={formData.Phone.error}
            id='PhoneNumberField'
            label='Phone Number'
            variant='outlined'
            value={formData.Phone.value}
            onChange={(e) =>
              setFormData({
                ...formData,
                Phone: { value: e.target.value, error: '' },
              })
            }
            helperText={formData.Phone.error}
            type='number'
            fullWidth
          />
        </Grid>
      </Grid>
    </Box>
  );
};

const ProductInfo = ({ planInfo }) => {
  return (
    <Grid container spacing={2}>
      <Grid item xs={6} sm={6} md={6}><Box>
        <img
          src='/spy/static/PegSpyDarkLogo.png'
          alt='PegSpy'
          style={{ maxWidth: '150px', height: 'auto', margin: "10px 0px" }}
        />
      </Box></Grid>
      <Grid item xs={6} sm={6} md={6}><Box>

        {/* <h4>{planInfo?.type}</h4> */}
        <h3>{planInfo?.title}</h3>

        <h4>${planInfo?.cost_price}</h4></Box></Grid>
    </Grid>
    // <div style={{ display: 'flex', alignItems: 'center', maxWidth: '300px' }}>
    //   <img
    //     src='/spy/static/PegSpyDarkLogo.png'
    //     alt='PegSpy'
    //     style={{ maxWidth: '150px', height: 'auto', margin: "10px 0px" }}
    //   />

    //   <div>
    // <h5>{planInfo?.type}</h5>
    // <h3>{planInfo?.title}</h3>

    // <h4>${planInfo?.cost_price}</h4>
    //   </div>
    // </div>
  );
};

export default StripeTestPage;
