import React from "react";
import { useEffect, useState } from "react";
// material
import {
  Card,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  Button,
} from "@mui/material";
// components
import Page from "../components/Page";
import Scrollbar from "../components/Scrollbar";
import SearchNotFound from "../components/SearchNotFound";
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from "../sections/@dashboard/utilityComponents";
//

import useDeviceId from "../hooks/useDeviceId";
import axios from "axios";

import useLanguage from "../hooks/useLanguage";
import AlignedTableCell from "src/sections/@dashboard/utilityComponents/AlignedTableCell";
import MuiIcon from "src/sections/@dashboard/utilityComponents/MuiIcon";
import CoupanDilog from "src/components/CoupanDilog";
import FeatureDilog from "src/components/FeatureDilog";
// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: "id", label: "ID", alignRight: false },
  { id: "icon", label: "ICON", alignRight: false },
  { id: "name", label: "NAME", alignRight: false },
  { id: "Path", label: "PATH", alignRight: false },
  { id: "parent_id", label: "PARENT ID", alignRight: false },
  { id: "management", label: "TYPE", alignRight: false },
  { id: "status", label: "STATUS", alignRight: false },
  { id: "action", label: "ACTION", alignRight: true },
];

// ----------------------------------------------------------------------
export default function FeaturesAdmin() {
  const [order, setOrder] = useState("asc");
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState("coupon_code");
  const [filter, setFilter] = useState("");
  const [callsList, setCallsList] = useState([]);
  const [handleModle, setHandleModle] = useState({open:false,update:false, data:false});
  const [newDataAdded, setNewDataAdded] = useState(0);

  const { deviceID, setDeviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const isUserNotFound = callsList.length === 0;

  useEffect(async () => {
    try {
      const result = await axios.get(`admin/master-feature-view`, {
        params: {
          search: filter,
        },
      });

      console.log(result);

      setCallsList(result.data.data);
    } catch (error) {
      console.log(error);
    }
  }, [ deviceID, filter,newDataAdded]);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = callsList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };
  const handleClickOpen = () => {
    setHandleModle({open:true, update:false,data:false});
  };

  const handleUpdateOpen = (data) => {
    setHandleModle({open:true,update:true,data});
  };

  const handleClose = (isUpdated) => {
    if (isUpdated === true) {
      setNewDataAdded((e) => ++e);
    }
    setHandleModle({open:false, update:false,data:false});
  };

  const handleFilter = (value) => {
    setFilter(value);
  };
  //-----------------------------------------------------

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[2].id;
    const isAsc = orderBy === sortId && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(sortId);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const filteredCallsList = applySortFilter(
    callsList,
    getComparator(order, orderBy),
    filter
  );

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }

  function getComparator(order, orderBy) {
    return order === "desc"
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  const  handleDeleteCoupan=async(id)=> {
      await axios.delete(`admin/master-feature-delete/${id}`);
      setNewDataAdded((e) => ++e);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }
  return (
    <Page title="Features">
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            Features
          </Typography>
          <div
            style={{
              display: "flex",
              justifyContent: "space-between",
              margin: "10px",
            }}
          >
            <Button
              onClick={handleClickOpen}
              size="large"
              variant="contained"
            >
              Create Feature
            </Button>
          </div>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder="Search..."
            numSelected={selected.length}
            onFilter={handleFilter}
          />

          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={callsList.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {filteredCallsList.map((row) => {
                    const {
                      id,
                      name,
                      icon,
                      parent_id,
                      status,
                      management,
                      path,
                    } = row;
                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role="checkbox"
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        <TableCell component="th" scope="row" padding="normal">
                          <Stack
                            direction="row"
                            alignItems="center"
                            spacing={2}
                          >
                            <Typography variant="subtitle2" noWrap>
                              {id}
                            </Typography>
                          </Stack>
                        </TableCell>

                        <AlignedTableCell flow="left">
                          <MuiIcon icon={icon} width='23px' height='23px'/>
                        </AlignedTableCell>
                        
                        <AlignedTableCell flow="left">
                          {name}
                        </AlignedTableCell>
                        <AlignedTableCell flow="left">
                        {path?path:"NOT AVAILABLE"}
                        </AlignedTableCell>
                        
                        <AlignedTableCell flow="left">
                          {parent_id?parent_id:"NOT AVAILABLE"}
                        </AlignedTableCell>
                        <AlignedTableCell flow="left">
                          {management?"MANAGEMENT":"CLIENT"}
                        </AlignedTableCell>
                        
                        <AlignedTableCell flow="left">
                          {status?"ACTIVE":"DISACTIVE"}
                        </AlignedTableCell>
                        <AlignedTableCell flow="right">
                        <UcMoreMenu handleEdit={handleUpdateOpen} data={row} handleDelete={handleDeleteCoupan} />
                        </AlignedTableCell>
                      </TableRow>
                    );
                  })}
                </TableBody>
                {isUserNotFound && (
                  <TableBody>
                    <TableRow>
                      <TableCell align="center" colSpan={6} sx={{ py: 3 }}>
                        <SearchNotFound searchQuery={filter} />
                      </TableCell>
                    </TableRow>
                  </TableBody>
                )}
              </Table>
            </TableContainer>
          </Scrollbar>
        </Card>
        {handleModle.open ? <FeatureDilog open={handleModle.open} handleClose={handleClose} update={handleModle.update} defaultData={handleModle.data}/> : null}
      </Container>
    </Page>
  );
}
