import { Card, Container, Stack, Tooltip, Typography } from '@mui/material';
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import Page from 'src/components/Page';
import { UcListRangToolbar } from 'src/sections/@dashboard/utilityComponents';

import useDeviceId from '../hooks/useDeviceId';
import useLanguage from '../hooks/useLanguage';

import GoogleMapReact from 'google-map-react';
import LocationOnIcon from '@mui/icons-material/LocationOn';
const GeoTracking = () => {
  const { deviceID, setDeviceID } = useDeviceId();
  const [filterData, setFilter] = useState({
    start_date: null,
    end_date: null,
  });
  const [locations, setLocations] = useState([]);

  const translate = useLanguage().translate;

  useEffect(async () => {
    let start_date = filterData.start_date;
    let end_date = filterData.end_date;

    if (!end_date) {
      let date = new Date();

      end_date = `${date.getFullYear()}-${
        date.getMonth() + 1
      }-${date.getDate()}`;
    }

    try {
      const result = await axios.get(`geo-tracking/${deviceID}`, {
        params: {
          start_date,
          end_date,
        },
      });
      setLocations(result.data.data);
    } catch (error) {
      console.log(error);
    }
  }, [deviceID, filterData]);

  const filter = (data) => {
    setFilter(data);
  };

  return (
    <Page title={translate('Tracking')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Tracking')}
          </Typography>
        </Stack>

        <Card>
          <UcListRangToolbar onFilter={filter} />

          <div style={{ height: '60vh', width: '100%' }}>
            <GoogleMapReact
              bootstrapURLKeys={{
                key: process.env.REACT_APP_GOOGLE_MAP_API_KEY,
              }}
              defaultCenter={{
                lat: Number(
                  locations.length ? locations[0].latitude : '44.968046'
                ),
                lng: Number(
                  locations.length ? locations[0].longitude : '-94.420307'
                ),
              }}
              defaultZoom={15}
            >
              {locations.map((item) => {
                return (
                  <Tooltip
                    style={{
                      marginTop: '-34px',
                      marginLeft: '-17px',
                      cursor: 'pointer',
                    }}
                    lat={Number(item.latitude)}
                    lng={Number(item.longitude)}
                    title={item.date_time}
                  >
                    <LocationOnIcon fontSize='large' color='error' />
                  </Tooltip>
                );
              })}
            </GoogleMapReact>
          </div>
        </Card>
      </Container>
    </Page>
  );
};

export default GeoTracking;
