import React, { useEffect, useState } from 'react';

import { Card, Container, Stack, Typography } from '@mui/material';

import ChatComponent from 'src/components/Chat/ChatComponent';

import useLanguage from '../hooks/useLanguage';
import useDeviceId from '../hooks/useDeviceId';
import Page from '../components/Page';
import axios from 'axios';

const logo =
  'https://cdn3.iconfinder.com/data/icons/social-media-2169/24/social_media_social_media_logo_imo-512.png';

const Imo_sms = () => {
  const [chats, setChats] = useState([]);
  const [Property, setProperty] = useState(null);
  const [messages, setMessages] = useState([]);
  const translate = useLanguage().translate;

  const { deviceID, setDeviceID } = useDeviceId();

  useEffect(async () => {
    try {
      const result = await axios.get(`/imo-sms/${deviceID}`);
      setChats(result.data.data);
    } catch (error) {
      console.log(error);
    }
  }, [deviceID]);

  useEffect(() => {
    const loadMessages = async () => {
      try {
        const result = await axios.get(`imo-sms-chats/${deviceID}`, {
          params: {
            name_val: Property,
          },
        });

        setMessages(result.data.data.imo_list);
      } catch (error) {
        console.log(error);
      }
    };

    if (Property) {
      loadMessages();
    } else {
      setMessages([]);
    }
  }, [Property, deviceID]);

  return (
    <Page title={translate('Imo Messages')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Imo Messages')}
          </Typography>
        </Stack>
        <Card>
          <ChatComponent
            field='contact_name'
            logo={logo}
            ChatList={chats}
            messages={messages}
            setProperty={setProperty}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default Imo_sms;
