import {
  Button,
  Card,
  Container,
  Stack,
  TextField,
  ToggleButton,
  ToggleButtonGroup,
  Typography,
} from '@mui/material';
import axios from 'axios';
import React, { useState } from 'react';
import AdminKeywords from 'src/components/KeywordAlert/AdminKeywords';
import SearchedKeyword from 'src/components/KeywordAlert/SearchedKeyword';
import Page from 'src/components/Page';

import useDeviceId from '../hooks/useDeviceId';
import useLanguage from '../hooks/useLanguage';

const KeyWordAleartPage = () => {
  const [alignment, setAlignment] = React.useState('Searched');
  const [toggle, setToggle] = useState(false);
  const [newkeyword, setNewKeyword] = useState('');
  const [updated, setUpdated] = useState(0);

  const { deviceID } = useDeviceId();

  const translate = useLanguage().translate;

  const handleChange = (_, newAlignment) => {
    setAlignment(newAlignment);
  };
  const hitKeywordApi = async (device_id, keyword) => {
    try {
      const result = await axios.post(`store-keyword/${device_id}`, null, {
        params: {
          keyword,
        },
      });
      console.log(result);
      setUpdated((item) => ++item);
    } catch (error) {
      console.log(error);
    }
  };

  return (
    <Page title={translate('Keyword Alart')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Keyword Alart')}
          </Typography>
        </Stack>
        <div
          style={{
            display: 'flex',
            justifyContent: 'space-between',
            margin: '10px',
          }}
        >
          {alignment === 'Searched' ? (
            <div></div>
          ) : (
            <>
              {toggle ? (
                <div style={{ display: 'flex' }}>
                  <TextField
                    onChange={(e) => setNewKeyword(e.target.value)}
                    value={newkeyword}
                    id='standard-basic'
                    label='New Keyword'
                    variant='standard'
                  />
                  {newkeyword === '' ? null : (
                    <Button
                      onClick={() => {
                        hitKeywordApi(deviceID, newkeyword);
                        setToggle(!toggle);
                        setNewKeyword('');
                      }}
                      style={{ marginLeft: '10px' }}
                      size='small'
                    >
                      Add
                    </Button>
                  )}
                </div>
              ) : (
                <Button
                  onClick={() => setToggle(!toggle)}
                  size='large'
                  variant='contained'
                >
                  Add new KeyWord
                </Button>
              )}
            </>
          )}
          <div style={{ textAlign: 'right' }}>
            <ToggleButtonGroup
              dir='ltr'
              color='primary'
              value={alignment}
              exclusive
              onChange={handleChange}
            >
              <ToggleButton value='Searched'>
                {translate('Searched')}
              </ToggleButton>
              <ToggleButton value='Kewords'>
                {translate('Keywords')}
              </ToggleButton>
            </ToggleButtonGroup>
          </div>
        </div>

        <Card>
          {alignment === 'Searched' ? (
            <SearchedKeyword translate={translate} />
          ) : (
            <AdminKeywords translate={translate} updated={updated} />
          )}
        </Card>
      </Container>
    </Page>
  );
};

export default KeyWordAleartPage;
