import React from 'react';
import { useEffect, useState } from 'react';
// material
import {
  Card,
  Table,
  Stack,
  Checkbox,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  Button,
  TableContainer,
  Tooltip,
  IconButton,
} from '@mui/material';
// components
import Page from '../components/Page';
import Scrollbar from '../components/Scrollbar';
import SearchNotFound from '../components/SearchNotFound';
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from '../sections/@dashboard/utilityComponents';
//
import MapModel from 'src/components/GoogleMap/MapModel';
import axios from 'axios';

import useDeviceId from '../hooks/useDeviceId';


import useLanguage from '../hooks/useLanguage';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';
import MuiIcon from 'src/sections/@dashboard/utilityComponents/MuiIcon';
// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: 'id', label: 'ID', alignRight: false },
  { id: 'map', label: 'MAP', alignRight: false },
  { id: 'address', label: 'ADDRESS', alignRight: false },
  { id: 'latitude', label: 'LATITUDE', alignRight: false },
  { id: 'longitude', label: 'LONGITUDE', alignRight: false },
  { id: 'date_time', label: 'DATE & TIME', alignRight: false },
  { id: 'action', label: 'ACTION', alignRight: false },
];

// ----------------------------------------------------------------------
function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

export default function Location() {
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [selected, setSelected] = useState([]);
  const [totalRow, setTotleRows] = useState(0);
  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('address');
  const [filter, setFilter] = useState('');
  const [lanLong, setlanLong] = useState(null);
  const [locationsList, setLocationsList] = useState([]);

  const { deviceID, setDeviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const handleClose = () => setlanLong(null);

  useEffect(async () => {
    try {
      const result = await axios.get(`locations/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });

      setTotleRows(result.data.data.total_count);
      setLocationsList(result.data.data.location_data);
    } catch (error) {
      console.log(error);
    }
  }, [rowsPerPage, page, deviceID, filter]);

  const isLanLongAvailable = () => {
    if (lanLong !== null) {
      return true;
    } else {
      return false;
    }
  };

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = locationsList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };
  

  const reload = async () => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "LOCATION",
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };

  const isUserNotFound = locationsList.length === 0;
  //-----------------------------

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[2].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const filterlocationsList = applySortFilter(
    locationsList,
    getComparator(order, orderBy),
    filter
  );

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }
  return (
    <Page title={translate('Location')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Location')}
            <IconButton onClick={reload} >
              <MuiIcon icon="pepicons:reload" width="25px" height="25px" />
            </IconButton>
          </Typography>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder='Search By Address...'
            numSelected={selected.length}
            onFilter={(value) => setFilter(value)}
          />

          <Scrollbar>
            <>
              <TableContainer sx={{ minWidth: 800 }}>
                <Table>
                  <UcListHead
                    order={order}
                    orderBy={orderBy}
                    headLabel={TABLE_HEAD}
                    rowCount={locationsList.length}
                    numSelected={selected.length}
                    onRequestSort={handleRequestSort}
                    onSelectAllClick={handleSelectAllClick}
                  />
                  <TableBody>
                    {filterlocationsList.map((row) => {
                      const {
                        id,
                        latitude,
                        longitude,
                        address,
                        date_time,
                        action,
                      } = row;
                      const isItemSelected = selected.indexOf(id) !== -1;

                      return (
                        <TableRow
                          hover
                          key={id}
                          tabIndex={-1}
                          role='checkbox'
                          selected={isItemSelected}
                          aria-checked={isItemSelected}
                        >
                          <AlignedTableCell flow='left'>
                            {id}
                          </AlignedTableCell>
                          <TableCell component='th' scope='row' padding='none'>
                            <Stack
                              direction='row'
                              alignItems='center'
                              spacing={2}
                            >
                              <Typography variant='subtitle2' noWrap>
                                <Tooltip title='مجھے دباؤ'>
                                  <Button
                                    onClick={() => {
                                      // setlanLong({ // Functional
                                      //   lat: latitude,
                                      //   lang: longitude,
                                      // });

                                      setlanLong({
                                        lat: '40.427260',
                                        lang: '-74.483840',
                                      });
                                    }}
                                    // variant="contained"
                                  >
                                    View Map
                                  </Button>
                                </Tooltip>
                              </Typography>
                            </Stack>
                          </TableCell>
                          <AlignedTableCell flow='left'>
                            <Typography variant='subtitle2' noWrap>
                              <MuiIcon icon='akar-icons:location' />
                              {address}
                            </Typography>
                          </AlignedTableCell>
                          <AlignedTableCell flow='left'>
                            {latitude}
                          </AlignedTableCell>

                          <AlignedTableCell flow='left'>
                            {longitude}
                          </AlignedTableCell>
                          
                          <AlignedTableCell flow='left'>
                            <Typography variant='subtitle2' noWrap>
                              <MuiIcon icon='system-uicons:calendar-date' />
                              {date_time}
                            </Typography>
                          </AlignedTableCell>
                          <AlignedTableCell flow='left'>
                            {action}
                            <UcMoreMenu />
                          </AlignedTableCell>
                        </TableRow>
                      );
                    })}
                  </TableBody>
                  {isUserNotFound && (
                    <TableBody>
                      <TableRow>
                        <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                          <SearchNotFound searchQuery={filter} />
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  )}
                </Table>
              </TableContainer>
              {lanLong ? (
                <MapModel
                  handleClose={handleClose}
                  isLanLongAvailable={isLanLongAvailable}
                  LatLang={lanLong}
                />
              ) : null}
            </>
          </Scrollbar>

          <MyTablePagination
            count={totalRow}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
}
