import {
  Container,
  Stack,
  Typography,
  Card,
  Button,
  CardHeader,
  Box,
  CardActions,
  CardContent,
  ListItem,
  Grid,
} from "@mui/material";

import axios from "axios";
import React, { useEffect, useState } from "react";
import Page from "src/components/Page";

import useLanguages from "../hooks/useLanguage";
import useAuth from "../hooks/useAuth";

import "../PlanCarddamy.css";
import { useNavigate, useParams } from "react-router-dom";

const tiers = [
  {
    title: "Premium",
    price: "15",
    description: [
      "Each subscription plan offers unique and high-end features. Pick the best one that perfectly fulfils your requirements.",
    ],
  },
];

const OurPlans = () => {
  const translate = useLanguages().translate;

  const { deviceId } = useParams();
  const { user } = useAuth();

  const navigate = useNavigate();

  const [plans, setPlans] = useState([]);
  const [selectedPlan, setSelectedPlan] = useState(plans[0]);
  useEffect(async () => {
    try {
      const result = await axios.get(`/plans`);
      const data = result.data.data.filter((item) => item.status === "1");
      setPlans(data);
    } catch (error) {
      console.log(error);
    }
  }, []);

  const submit = (id) => {
    if (deviceId) {
      navigate(`../../renew-plan/${deviceId}/plan/${id}`);
    } else {
      navigate(`../../CheckOut/${id}`);
    }
  };

  return (
    <Page title={translate("Plans")}>
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            {translate("Plans")}
          </Typography>
        </Stack>

        <Grid container spacing={2} alignItems="flex-end">
          {plans.map((tier, i) => {
            return (
              <Grid
                item
                key={tier.title}
                xs={12}
                sm={tier.title === "Enterprise" ? 12 : 6}
                md={3}
              >
                <Card
                  sx={{
                    backgroundSize: "cover",
                    maxWidth: "300px",
                  }}
                >
                  <Box sx={{
                    backgroundColor: "secondary.main", padding: "10px 0px",
                  }}>
                    <CardHeader
                      title={tier.title}
                      titleTypographyProps={{ align: "center" }}
                      action={tier.title === "Pro"}
                      sx={{ color: "white" }}
                    // subheaderTypographyProps={{
                    //   position: "absolute",
                    //   top: "-50px",
                    //   padding: "20px",
                    //   zIndex: "9999",
                    //   align: "center",
                    //   left: "0px",
                    //   right: "0px",
                    //   backgroundColor: "black",
                    //   color: "text.white",
                    //   maxWidth: "100px",
                    //   borderRadius: "50%",
                    //   margin: "auto",
                    // }}
                    />
                    <CardContent>
                      <Box
                        sx={{
                          display: "flex",
                          justifyContent: "center",
                          alignItems: "baseline",
                          mb: 2,
                        }}
                      >
                        <Typography
                          variant="h6"
                          color={
                            tier.backgroundImage ? "text.white" : "primary.main"
                          }
                        >
                          $
                        </Typography>
                        <Typography
                          component="h1"
                          variant="h1"
                          color={
                            tier.backgroundImage ? "text.white" : "primary.main"
                          }
                        >
                          {tier.cost_price}
                        </Typography>
                        <Typography
                          variant="h6"
                          color={
                            tier.backgroundImage ? "text.white" : "primary.main"
                          }
                        >
                          /Month
                        </Typography>
                      </Box>
                      <Typography
                        variant="subtitle1"
                        align="center"
                        sx={{ color: "white" }}
                      >
                        {tier.description}
                      </Typography>
                    </CardContent>
                    <CardActions>
                      <Button
                        onClick={(e) => {
                          e.preventDefault();
                          submit(tier.id);
                        }}
                        sx={{
                          backgroundColor: 'white',
                          border: '0.5px solid #D8D9DC',
                          boxShadow: 'none',
                          '&:hover': {
                            border: '0.5px solid #AFD402',
                          },
                          margin: "auto",
                          display: "block",
                          minWidth: '140px',
                          maxWidth: '140px',
                        }}
                        variant="contained"
                      >
                        Buy Plan
                      </Button>
                    </CardActions>
                  </Box>
                  <CardContent>
                    <ul>
                      {user.permission &&
                        user.permission.map((item) => (
                          <ListItem
                            key={item.id}
                            sx={{ borderBottom: "1px solid #00000016", display: "block", textAlign: "center" }}
                          >
                            {item.name}
                          </ListItem>
                        ))}
                    </ul>
                  </CardContent>
                  <Button
                    onClick={(e) => {
                      e.preventDefault();
                      submit(tier.id);
                    }}
                    // className="white_btn"
                    variant="contained" size="Large"
                    sx={{ margin: "auto", display: "block", margin: "20px auto" }}
                  >
                    Buy Plan
                  </Button>
                </Card>
              </Grid>
            );
          })}
        </Grid>
      </Container>
    </Page>
  );
};

export default OurPlans;
