import React from "react";
import { useEffect, useState } from "react";
// material
import {
  Card,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  Button,
} from "@mui/material";
// components
import Page from "../components/Page";
import Scrollbar from "../components/Scrollbar";
import {
  UcListHead,
  UcMoreMenu,
} from "../sections/@dashboard/utilityComponents";
//
import axios from "axios";

import AlignedTableCell from "src/sections/@dashboard/utilityComponents/AlignedTableCell";
import PlanDilog from "src/components/PlanDilog";
// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: "title", label: "TITLE", alignRight: false },
  { id: "cost_price", label: "COST PRICE", alignRight: false },

  { id: "description", label: "DESCRIPTION", alignRight: false },
  { id: "status", label: "STATUS", alignRight: false },
  { id: "action", label: "ACTION", alignRight: true },
];

// ----------------------------------------------------------------------
export default function CoponsPage() {
  const [order, setOrder] = useState("asc");
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState("coupon_code");
  const [data, setData] = useState([]);
  const [handleModle, setHandleModle] = useState({ open: false, update: false, data: false });
  const [newDataAdded, setNewDataAdded] = useState(0);

  useEffect(async () => {
    try {
      const result = await axios.get(`admin/plan-view`);
      console.log(result);
      setData(result.data.data);
    } catch (error) {
      console.log(error);
    }
  }, [newDataAdded]);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = callsList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };
  const handleClickOpen = () => {
    setHandleModle({ open: true, update: false, data: false });
  };

  const handleUpdateOpen = (data) => {
    setHandleModle({ open: true, update: true, data });
  };

  const handleClose = (isUpdated) => {
    if (isUpdated === true) {
      setNewDataAdded((e) => ++e);
    }
    setHandleModle({ open: false, update: false, data: false });
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };



  const handleDeletePlan = async (id) => {
    await axios.delete(`/admin/plan-delete/${id}`);
    setNewDataAdded((e) => ++e);
  }

  return (
    <Page title="Plans">
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            Plans
          </Typography>

          <div
            style={{
              display: "flex",
              justifyContent: "space-between",
              margin: "10px",
            }}
          >
            <Button
              onClick={handleClickOpen}
              size="large"
              variant="contained"
            >
              Create Plan
            </Button>
          </div>
        </Stack>

        <Card>
          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={data.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {data.map((row) => {
                    const {
                      id,
                      title,
                      cost_price,
                      description,
                      status
                    } = row;
                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role="checkbox"
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        <TableCell component="th" scope="row" padding="normal">
                          <Stack
                            direction="row"
                            alignItems="center"
                            spacing={2}
                          >
                            <Typography variant="subtitle2" noWrap>
                              {title}
                            </Typography>
                          </Stack>
                        </TableCell>

                        <AlignedTableCell flow="left">
                          {cost_price}
                        </AlignedTableCell>
                        <AlignedTableCell flow="left">
                          {description}
                        </AlignedTableCell>


                        <AlignedTableCell flow="left">
                          {status ? "Enable" : "Disable"}
                        </AlignedTableCell>

                        <AlignedTableCell flow="right">
                          <UcMoreMenu handleEdit={handleUpdateOpen} data={row} handleDelete={handleDeletePlan} />
                        </AlignedTableCell>
                      </TableRow>
                    );
                  })}
                </TableBody>

              </Table>
            </TableContainer>
          </Scrollbar>


        </Card>
        {handleModle.open ? <PlanDilog open={handleModle.open} handleClose={handleClose} update={handleModle.update} defaultData={handleModle.data} /> : null}
      </Container>
    </Page>
  );
}
