import React from 'react';

import { styled } from '@mui/material/styles';
import { Stack, Container, Typography } from '@mui/material';

import Page from '../components/Page';
import RecoverPassForm from '../sections/authentication/RecoverPass/RecoverPassForm';

const ResetPass = () => {
  const RootStyle = styled(Page)(({ theme }) => ({
    [theme.breakpoints.up('md')]: {
      display: 'flex',
    },
  }));

  const ContentStyle = styled('div')(({ theme }) => ({
    maxWidth: 480,
    margin: 'auto',
    display: 'flex',
    minHeight: '100vh',
    flexDirection: 'column',
    justifyContent: 'center',
    padding: theme.spacing(12, 0),
  }));

  return (
    <RootStyle title='ForgetPass | Minimal-UI'>
      <Container maxWidth='sm'>
        <ContentStyle>
          <Stack sx={{ mb: 5 }}>
            <Typography variant='h4' gutterBottom>
              Forgot your password?
            </Typography>
            <Typography sx={{ color: 'text.secondary' }}>
              Please enter the email address associated with your account and We
              will email you a link to reset your password.
            </Typography>
          </Stack>

          <RecoverPassForm />
        </ContentStyle>
      </Container>
    </RootStyle>
  );
};

export default ResetPass;
