import React from "react";
import { useEffect, useState } from "react";
// material
import {
  Card,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  Button,
} from "@mui/material";
// components
import Page from "../components/Page";
import Scrollbar from "../components/Scrollbar";
import {
  UcListHead,
  UcMoreMenu,
} from "../sections/@dashboard/utilityComponents";
//
import axios from "axios";

import AlignedTableCell from "src/sections/@dashboard/utilityComponents/AlignedTableCell";
import PlanDilog from "src/components/PlanDilog";
import RoleDilog from "src/components/RoleDIlog";
import MuiIcon from "src/sections/@dashboard/utilityComponents/MuiIcon";
// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: "id", label: "ID", alignRight: false },
  { id: "title", label: "TITLE", alignRight: false },
  { id: "permission", label: "PERMISSION", alignRight: false },
  { id: "description", label: "DESCRIPTION", alignRight: false },
  { id: "action", label: "ACTION", alignRight: true },
];

// ----------------------------------------------------------------------
export default function RolesAdmin() {
  const [order, setOrder] = useState("asc");
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState("coupon_code");
  const [data, setData] = useState([]);
  const [handleModle, setHandleModle] = useState({
    open: false,
    update: false,
    data: false,
  });
  const [newDataAdded, setNewDataAdded] = useState(0);
  const [features, setFeatures] = useState([]);

  useEffect(async () => {
    try {
      const result = await axios.get(`admin/role-view`);
      console.log(result);
      setData(result.data);
    } catch (error) {
      console.log(error);
    }
  }, [newDataAdded]);

  useEffect(async () => {
    try {
      const result = await axios.get(`admin/master-feature-view`);
      const list = result.data.data.filter((item) => !!item.path);
      setFeatures(result.data.data.filter((item) => !!item.path));
    } catch (error) {
      console.log(error);
    }
  }, []);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = callsList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };
  const handleClickOpen = () => {
    setHandleModle({ open: true, update: false, data: false });
  };

  const handleUpdateOpen = (data) => {
    setHandleModle({ open: true, update: true, data });
  };

  const handleClose = (isUpdated) => {
    if (isUpdated === true) {
      setNewDataAdded((e) => ++e);
    }
    setHandleModle({ open: false, update: false, data: false });
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const handleDeletePlan = async (id) => {
    await axios.delete(`/admin/role-delete/${id}`);
    setNewDataAdded((e) => ++e);
  };

  return (
    <Page title="Roles">
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            Roles
          </Typography>

          <div
            style={{
              display: "flex",
              justifyContent: "space-between",
              margin: "10px",
            }}
          >
            <Button onClick={handleClickOpen} size="large" variant="contained">
              Create Role
            </Button>
          </div>
        </Stack>

        <Card>
          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={data.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {data.map((row) => {
                    const { id, name, permission, description } = row;

                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role="checkbox"
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        <AlignedTableCell flow="left">{id}</AlignedTableCell>
                        <TableCell component="th" scope="row" padding="normal">
                          <Stack
                            direction="row"
                            alignItems="center"
                            spacing={2}
                          >
                            <Typography variant="subtitle2" noWrap>
                              {name}
                            </Typography>
                          </Stack>
                        </TableCell>

                        <AlignedTableCell flow="left">
                          <MuiIcon
                            icon="material-symbols:done"
                            width="15px"
                            height="15px"
                          />
                          {permission
                            ? permission.split(",").length
                            : "unavailable"}
                        </AlignedTableCell>

                        <AlignedTableCell flow="left">
                          {description}
                        </AlignedTableCell>

                        <AlignedTableCell flow="right">
                          <UcMoreMenu
                            handleEdit={handleUpdateOpen}
                            data={{
                              ...row,
                              permission:
                                row.permission &&
                                row.permission
                                  .split(",")
                                  .map((item) => Number(item)),
                            }}
                            disabledelete={true}
                            handleDelete={handleDeletePlan}
                          />
                        </AlignedTableCell>
                      </TableRow>
                    );
                  })}
                </TableBody>
              </Table>
            </TableContainer>
          </Scrollbar>
        </Card>
        {handleModle.open ? (
          <RoleDilog
            open={handleModle.open}
            features={features}
            handleClose={handleClose}
            update={handleModle.update}
            defaultData={handleModle.data}
          />
        ) : null}
      </Container>
    </Page>
  );
}
