import { Card, Container, Stack, Typography } from '@mui/material';
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import Page from 'src/components/Page';
import Videos from 'src/components/Videos/Videos';
import useDeviceId from '../hooks/useDeviceId';

import { Button } from '@mui/material';
import { UcListRangToolbar } from 'src/sections/@dashboard/utilityComponents';

import useLanguage from '../hooks/useLanguage';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';

const ScreenRecording = () => {
  const [selected, setSeleted] = useState([]);
  const [VideosList, setVideos] = useState([]);
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(20);
  const [total_count,setTotal_Count] = useState(0);
  const { deviceID, setDeviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const [filterData, setFilter] = useState({
    start_date: null,
    end_date: null,
  });

  const filter = (value) => {
    setFilter(value);
  };

  useEffect(async () => {
    try {
      const result = await axios.get(`record-screen/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          start_date: filterData.start_date,
          end_date: filterData.end_date,
        },
      });
      setVideos(result.data.data.recording_data);
      setTotal_Count(result.data.data.total_count)
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filterData]);

  //this action is for image download button.
  const downloadAction = (Id) => {
    console.log(`Download : =>${Id}`);
  };

  const startRecording = async() => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "SCREEN_RECORDING",
          time: 30000
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };

  return (
    <Page title={translate('Screen Recording')}>
      <Container>
        <div
          style={{
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'space-between',
          }}
        >
          <Stack
            direction='row'
            alignItems='center'
            justifyContent='space-between'
            mb={5}
          >
            <Typography variant='h4' gutterBottom>
              {translate('Screen Recording')}
            </Typography>
          </Stack>
          <Button
            onClick={startRecording}
            sx={{
              mt: 2,
            }}
            size='large'
            variant='contained'
          >
            Start Recording
          </Button>
        </div>
        <Card style={{ padding: '10px' }}>
          <UcListRangToolbar numSelected={selected.length} onFilter={filter} />
          <Videos
            selected={selected}
            setSeleted={setSeleted}
            VideosList={VideosList}
            filter={filter}
            downloadAction={downloadAction}
          />
          <MyTablePagination
            count={total_count}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default ScreenRecording;
