import React, { useEffect, useState } from 'react';
import ImagesComponent from 'src/components/Image/ImagesComponent';
import { Card, Container, Stack, Typography } from '@mui/material';
import Page from 'src/components/Page';
import useDeviceId from '../hooks/useDeviceId';
import axios from 'axios';
import { saveAs } from 'file-saver';
import { Button } from '@mui/material';

import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import FormControl from '@mui/material/FormControl';
import FormLabel from '@mui/material/FormLabel';
import { UcListRangToolbar } from 'src/sections/@dashboard/utilityComponents';

import useLanguage from '../hooks/useLanguage';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import { TurnedIn } from '@material-ui/icons';

const TakePicture = () => {
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(20);
  const [selected, setSeleted] = useState([]);
  const [Images, setImages] = useState([]);
  const { deviceID } = useDeviceId();
  const [total_count,setTotal_Count] = useState(0);
  const translate = useLanguage().translate;

  const [toggle, setToggle] = useState('front');
  const [filterData, setFilter] = useState({
    start_date: null,
    end_date: null,
  });

  useEffect(async () => {
    try {
      const result = await axios.get(`take-picture/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          start_date: filterData.start_date,
          end_date: filterData.end_date,
        },
      });
      setImages(result.data.data.takepicture_data);
      setTotal_Count(result.data.data.total_count);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filterData]);
  const downloadAction = (url) => {
    const originalImage = url;
    saveAs(originalImage, 'image.jpg'); // Put your image url here.
  };

  const filter = (data) => {
    setFilter(data);
  };
  const capture = async() => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "REMOTE_IMAGE",
          backCam: toggle==="front"?false:true
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };


  return (
    <Page title={translate('Take Picture')}>
      <Container>
        <div
          style={{
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'space-between',
          }}
        >
          <Stack
            direction='row'
            alignItems='center'
            justifyContent='space-between'
            mb={5}
          >
            <Typography variant='h4' gutterBottom>
              {translate('Take Picture')}
            </Typography>
          </Stack>

          <div>
            {toggle ? (
              <Button
                onClick={capture}
                style={{ marginRight: '15px', marginTop: '5px' }}
                size='large'
                variant='contained'
              >
                Capture
              </Button>
            ) : null}

            <FormControl>
              <FormLabel id='demo-radio-buttons-group-label'>
                <b>Select Camera</b>
              </FormLabel>
              <RadioGroup
                onChange={(e) => {
                  setToggle(e.target.value);
                }}
                value={toggle}
                row
                aria-labelledby='demo-radio-buttons-group-label'
                name='radio-buttons-group'
              >
                <FormControlLabel
                  value='front'
                  control={<Radio />}
                  label='Front'
                />
                <FormControlLabel
                  value='back'
                  control={<Radio />}
                  label='Back'
                />
              </RadioGroup>
            </FormControl>
          </div>
        </div>
        <Card style={{ padding: '10px' }}>
          <UcListRangToolbar numSelected={selected.length} onFilter={filter} />
          <ImagesComponent
            Images={Images}
            filter={filter}
            selected={selected}
            setSeleted={setSeleted}
            downloadAction={downloadAction}
          />
          <MyTablePagination
            count={total_count}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default TakePicture;
