import React, { useEffect, useState } from 'react';

import { Card, Container, Stack, Typography } from '@mui/material';

import ChatComponent from 'src/components/Chat/ChatComponent';

import useDeviceId from '../hooks/useDeviceId';
import useLanguage from '../hooks/useLanguage';
import Page from '../components/Page';
import axios from 'axios';

const logo = 'https://www.freepnglogos.com/uploads/telegram-logo-png-0.png';

const Telegram_sms = () => {
  const [chats, setChats] = useState([]);
  const [Property, setProperty] = useState(null);
  const [messages, setMessages] = useState([]);

  const translate = useLanguage().translate;
  const { deviceID } = useDeviceId();

  useEffect(async () => {
    try {
      const result = await axios.get(`/telegram-sms/${deviceID}`);
      setChats(result.data.data);
    } catch (error) {
      console.log(error);
    }
  }, [deviceID]);

  useEffect(() => {
    const loadMessages = async () => {
      try {
        const result = await axios.get(`telegram-sms-chats/${deviceID}`, {
          params: {
            name_val: Property,
          },
        });
        setMessages(result.data.data.telegram_list);
      } catch (error) {
        console.log(error);
      }
    };

    if (Property) {
      loadMessages();
    } else {
      setMessages([]);
    }
  }, [Property, deviceID]);

  return (
    <Page title={translate('Telegram Messages')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
          {translate('Telegram Messages')}
          </Typography>
        </Stack>
        <Card>
          <ChatComponent
            field='contact_name'
            logo={logo}
            ChatList={chats}
            messages={messages}
            setProperty={setProperty}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default Telegram_sms;
