import { Card, Container, IconButton, Stack, Typography } from '@mui/material';
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import Page from 'src/components/Page';
import Videos from 'src/components/Videos/Videos';
import { UcListRangToolbar } from 'src/sections/@dashboard/utilityComponents';
import MuiIcon from 'src/sections/@dashboard/utilityComponents/MuiIcon';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import useDeviceId from '../hooks/useDeviceId';

import useLanguage from '../hooks/useLanguage';

const VideosPage = () => {
  const [selected, setSeleted] = useState([]);
  const [VideosList, setVideos] = useState([]);
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(20);

  const [total_count, setTotalCount] = useState(0);
  const { deviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const [filterData, setFilter] = useState({
    start_date: null,
    end_date: null,
  });

  const filter = (value) => {
    setFilter(value);
  };

  useEffect(async () => {
    try {
      const result = await axios.get(`uservideo/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          start_date: filterData.start_date,
          end_date: filterData.end_date,
        },
      });
      console.log(result)
      setVideos(result.data.data.uservideo_data);
      setTotalCount(result.data.data.total_count)
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filterData]);

  //this action is for image download button.
  const downloadAction = (Id) => {
    console.log(`Download : =>${Id}`);
  };

  

  const reload = async () => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "VIDEOS",
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };

  return (
    <Page title={translate('Videos')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Videos')}
            <IconButton onClick={reload} >
              <MuiIcon icon="pepicons:reload" width="25px" height="25px" />
            </IconButton>
          </Typography>
        </Stack>
        <Card style={{ padding: '10px' }}>
          <UcListRangToolbar numSelected={selected.length} onFilter={filter} />
          <Videos
            selected={selected}
            setSeleted={setSeleted}
            VideosList={VideosList}
            filter={filter}
            downloadAction={downloadAction}
          />

          <MyTablePagination
            count={total_count}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default VideosPage;
