import { useEffect, useState } from 'react';
// material
import {
  Card,
  FormGroup,
  FormControlLabel,
  Switch,
  Button,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  Tooltip,
} from '@mui/material';
// components
import Page from '../components/Page';
import Scrollbar from '../components/Scrollbar';
import SearchNotFound from '../components/SearchNotFound';
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from '../sections/@dashboard/utilityComponents';
//
import axios from 'axios';
// ----------------------------------------------------------------------

import useDeviceId from '../hooks/useDeviceId';

import useLanguage from '../hooks/useLanguage';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';

const TABLE_HEAD = [
  { id: 'id', label: 'ID', alignRight: false },
  { id: 'website_name', label: 'NAME', alignRight: false },
  { id: 'website_url', label: 'URL', alignRight: false },
  { id: 'status', label: 'BLOCK/UNBLOCK', alignRight: false },
];
// ----------------------------------------------------------------------

export default function WebBlock() {
  const [page, setPage] = useState(0);
  const [order, setOrder] = useState('asc');
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState('name');
  const [filter, setFilter] = useState('');
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [list, setList] = useState([]);
  const [reload,setReload] = useState(0);

  const [totalrows, settotalrows] = useState(0);

  const { deviceID } = useDeviceId();
  const translate = useLanguage().translate;

  useEffect(async () => {
    try {
      const result = await axios.get(`websiteblock/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      console.log(result);
      setList(result.data.data.websiteblock_data);
      settotalrows(result.data.data.total_count);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, filter, deviceID,reload]);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = list.map((n) => n.name);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };
  const handleFilter = (value) => {
    setFilter(value);
  };

  const handleCheckedChange = ({ id, checked }) => {
    //hare

    setReload((pri)=>pri+1)
  };


  const isAppBlockNotFound = list.length === 0;
  //-----------------------------------------

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[1].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };
  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const filterlist = applySortFilter(
    list,
    getComparator(order, orderBy),
    filter
  );

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });
    return stabilizedThis.map((el) => el[0]);
  }

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }
  return (
    <Page title={translate('Website Block')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Website Block')}
          </Typography>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder='Search...'
            numSelected={selected.length}
            onFilter={handleFilter}
          />

          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={totalrows.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {filterlist.map((row) => {
                    const { id, website_name, website_url, status, action } =
                      row;
                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role='checkbox'
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        <AlignedTableCell flow='left'>
                          {id}
                        </AlignedTableCell>

                        <TableCell component='th' scope='row' padding='normal'>
                          <Stack
                            direction='row'
                            alignItems='center'
                            spacing={2}
                          >
                            <Typography variant='subtitle2' noWrap>
                              {website_name}
                            </Typography>
                          </Stack>
                        </TableCell>

                        <AlignedTableCell flow='left'>
                          {website_url}
                        </AlignedTableCell>

                        <AlignedTableCell flow='left'>
                          <FormGroup>
                            <FormControlLabel
                              control={
                                status ? (
                                  <Switch
                                    defaultChecked
                                    onChange={(e) =>
                                      handleCheckedChange({
                                        id: id,
                                        checked: e.target.checked,
                                      })
                                    }
                                  />
                                ) : (
                                  <Switch
                                    onChange={(e) =>
                                      handleCheckedChange({
                                        id: id,
                                        checked: e.target.checked,
                                      })
                                    }
                                  />
                                )
                              }
                              label={status ? <>Block</> : <>unblock</>}
                            />
                          </FormGroup>
                        </AlignedTableCell>

                      </TableRow>
                    );
                  })}
                  </TableBody>
                {isAppBlockNotFound && (
                  <TableBody>
                    <TableRow>
                      <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                        <SearchNotFound searchQuery={filter} />
                      </TableCell>
                    </TableRow>
                  </TableBody>
                )}
              </Table>
            </TableContainer>
          </Scrollbar>

          <MyTablePagination
            count={totalrows}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
}
