import React from "react";
import { useEffect, useState } from "react";
// material
import {
  Card,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  IconButton,
} from "@mui/material";
// components
import Page from "../components/Page";
import Scrollbar from "../components/Scrollbar";
import SearchNotFound from "../components/SearchNotFound";
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from "../sections/@dashboard/utilityComponents";

// Importing custom hooks
import useDeviceId from "../hooks/useDeviceId";
import useLanguage from "../hooks/useLanguage";

import axios from "axios";
import Iconify from "src/components/Iconify";
import MyTablePagination from "src/sections/@dashboard/utilityComponents/MyTablePagination";
import AlignedTableCell from "src/sections/@dashboard/utilityComponents/AlignedTableCell";
import MuiIcon from "src/sections/@dashboard/utilityComponents/MuiIcon";

const TABLE_HEAD = [
  { id: "id", label: "ID", alignRight: false },
  { id: "name", label: "NAME", alignRight: false },
];

//
const WifiLoger = () => {
  const [page, setPage] = useState(0);
  const [totalRow, setTotleRows] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [filter, setFilter] = useState("");
  const [selected, setSelected] = useState([]);
  const [wifiLogs, setWifiLogs] = useState([]);

  const { deviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const [order, setOrder] = useState("asc");
  const [orderBy, setOrderBy] = useState("name");

  useEffect(async () => {
    try {
      const result = await axios.get(`wifilogger/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      console.log(result);
      setTotleRows(result.data.data.total_count);
      setWifiLogs(result.data.data.wifi_logger);
    } catch (error) {
      console.log(error);
    }
  }, [rowsPerPage, page, deviceID, filter]);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = wifiLogs.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  const isUserNotFound = wifiLogs.length === 0;
  //-----------------------------------------

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[1].id;
    const isAsc = orderBy === sortId && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(sortId);
  };
  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const filteredWifiList = applySortFilter(
    wifiLogs,
    getComparator(order, orderBy),
    filter
  );

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });
    return stabilizedThis.map((el) => el[0]);
  }

  function getComparator(order, orderBy) {
    return order === "desc"
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }

  const reload = async () => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "WIFI_LOGS",
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };

  //-----------------------------------------------
  return (
    <Page title={translate("Wifi Logger")}>
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            {translate("Wifi Logger")}
            <IconButton onClick={reload}>
              <MuiIcon icon="pepicons:reload" width="25px" height="25px" />
            </IconButton>
          </Typography>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder="Search By Name..."
            numSelected={selected.length}
            onFilter={(value) => setFilter(value)}
          />
          <Scrollbar>
            <>
              <TableContainer sx={{ minWidth: 800 }}>
                <Table>
                  <UcListHead
                    order={order}
                    orderBy={orderBy}
                    headLabel={TABLE_HEAD}
                    rowCount={wifiLogs.length}
                    numSelected={selected.length}
                    onRequestSort={handleRequestSort}
                    onSelectAllClick={handleSelectAllClick}
                  />
                  <TableBody>
                    {filteredWifiList.map((row) => {
                      const { id, name, action } = row;
                      const isItemSelected = selected.indexOf(id) !== -1;

                      return (
                        <TableRow
                          hover
                          key={id}
                          tabIndex={-1}
                          role="checkbox"
                          selected={isItemSelected}
                          aria-checked={isItemSelected}
                        >
                          <AlignedTableCell flow="left">
                            <Typography variant="subtitle2" noWrap>
                              
                              {id}
                            </Typography>
                          </AlignedTableCell>
                          <AlignedTableCell flow="left">
                            <Typography variant="subtitle2" noWrap>
                              <MuiIcon icon="bx:wifi" />

                              {name}
                            </Typography>
                          </AlignedTableCell>
                        </TableRow>
                      );
                    })}
                  </TableBody>
                  {isUserNotFound && (
                    <TableBody>
                      <TableRow>
                        <TableCell align="center" colSpan={6} sx={{ py: 3 }}>
                          <SearchNotFound searchQuery={filter} />
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  )}
                </Table>
              </TableContainer>
            </>
          </Scrollbar>

          <MyTablePagination
            count={totalRow}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default WifiLoger;
