import { merge } from 'lodash';
import ReactApexChart from 'react-apexcharts';
// material
import { Box, Card, CardHeader } from '@mui/material';
// utils
import { fNumber } from '../../../utils/formatNumber';
//
import { BaseOptionChart } from '../../../components/charts';
import { useEffect, useState } from 'react';

import React from 'react';
// ----------------------------------------------------------------------

export default function AppConversionRates({ translate, counters }) {
  const [CHART_DATA, setCHART_DATA] = useState([1, 2, 3, 4, 5, 6, 7]);

  useEffect(() => {
    if (Object.keys(counters).length) {
      setCHART_DATA([
        counters.calllog_count,
        counters.sms_count,
        counters.calendar_count,
        counters.loction_count,
        counters.voices_count,
        counters.gallery_count,
        counters.videos_count,
      ]);
    }
  }, [counters]);

  const chartOptions = merge(BaseOptionChart(), {
    tooltip: {
      marker: { show: true },
      y: {
        formatter: (seriesName) => fNumber(seriesName),
        title: {
          formatter: (seriesName) => `#${translate('Total')}:`,
        },
      },
    },
    plotOptions: {
      bar: { vertical: true, barHeight: '28%', borderRadius: 2 },
    },
    xaxis: {
      categories: [
        translate('Call Logs'),
        translate('Sms'),
        translate('Calender Events'),
        translate('Locations'),
        translate('Voices'),
        translate('Images'),
        translate('Videos'),
      ],
    },
  });

  return (
    <Card>
      <CardHeader title={translate('Phone Activities')} />
      <Box sx={{ mx: 3 }} dir='ltr'>
        <ReactApexChart
          type='bar'
          series={[{ data: CHART_DATA }]}
          options={chartOptions}
          height={364}
        />
      </Box>
    </Card>
  );
}
