// material
import { alpha, styled } from '@mui/material/styles';
import { Card, Typography } from '@mui/material';
// utils
import React from 'react';
//
import Iconify from '../../../components/Iconify';
import MuiIcon from '../utilityComponents/MuiIcon';

// ----------------------------------------------------------------------

const RootStyle = styled(Card)(({ theme }) => ({
  boxShadow: 'none',
  textAlign: 'center',
  padding: theme.spacing(5, 0),
  
  color: theme.palette.common.black,
  backgroundColor: "#C0EFFE",
  minHeight: '310px',
}));

const IconWrapperStyle = styled('div')(({ theme }) => ({
  margin: 'auto',
  display: 'flex',
  borderRadius: '50%',
  alignItems: 'center',
  width: theme.spacing(8),
  height: theme.spacing(8),
  justifyContent: 'center',
  marginBottom: theme.spacing(3),
  color: theme.palette.warning.dark,
  backgroundImage: `linear-gradient(135deg, ${alpha(
    theme.palette.warning.dark,
    0
  )} 0%, ${alpha(theme.palette.warning.dark, 0.24)} 100%)`,
}));

// ----------------------------------------------------------------------

const TOTAL = 1723315;

export default function Licence({ translate, licenceKey }) {

  return (
    <RootStyle>
      <div style={{backgroundColor:'white',display:'inline-block',padding:'20px',borderRadius:'50px',border:'2px solid #A1E8FF'}} >
      <img src='/images/lincence.png'/>
      </div>
      
      {/* <IconWrapperStyle>
        <MuiIcon icon='arcticons:asr-licence' width={24} height={24} />
      </IconWrapperStyle> */}
      
      {/* <Typography variant="h3">{fShortenNumber(TOTAL)}</Typography> */}
      <Typography variant='h3'>{translate('Licence')}</Typography>
      <Typography variant='subtitle2' sx={{ opacity: 0.72 }}>
        {translate('License Key')} : {licenceKey}
      </Typography>
      <Typography variant='subtitle2' sx={{ opacity: 0.72 }}>
        {translate('Accessibility')}
      </Typography>
    </RootStyle>
  );
}
