import { Link as RouterLink } from 'react-router-dom';
// material
import {
  Box,
  Stack,
  Card,
  Button,
  Divider,
  Typography,
  CardHeader,
  Avatar,
} from '@mui/material';
// utils
import Scrollbar from '../../../components/Scrollbar';
import Iconify from '../../../components/Iconify';
import React from 'react';
import MuiIcon from '../utilityComponents/MuiIcon';

// ----------------------------------------------------------------------

// ----------------------------------------------------------------------

function NewsItem({ news }) {
  const { name, type, date_time } = news;

  return (
    <Stack direction='row' alignItems='center' spacing={2}>
      <Avatar alt='avatar' />

      <Box sx={{ width: '100%' }}>
        <Typography variant='subtitle2' noWrap>
          {name}
        </Typography>

        <Typography variant='body2' sx={{ color: 'text.secondary' }} noWrap>
          {type}
        </Typography>
      </Box>
      <Typography
        variant='caption'
        sx={{ pr: 3, flexShrink: 0, color: 'text.secondary' }}
      >
        {date_time}
        {/* {formatDistance(postedAt, new Date())} */}
      </Typography>
    </Stack>
  );
}

export default function Newcall({ translate, CallsList }) {
  return (
    <Card>
      <CardHeader title={translate('Last Calls')} />

      <Scrollbar>
        <Stack spacing={3} sx={{ p: 3, pr: 0 }}>
          {CallsList.map((news) => (
            <NewsItem key={news.id} news={news} />
          ))}
        </Stack>
      </Scrollbar>

      <Divider />

      <Box sx={{ p: 2, textAlign: 'right' }}>
        <Button
          component={RouterLink}
          to='../calls-list'
          size='small'
          color='inherit'
          endIcon={<MuiIcon icon='eva:arrow-ios-forward-fill' />}
        >
          {translate('View all')}
        </Button>
      </Box>
    </Card>
  );
}
