import { TableCell } from "@mui/material";
import React from "react";

import useLanguage from "../../../hooks/useLanguage";
const AlignedTableCell = ({ flow, children }) => {
  const { language } = useLanguage();
  return (
    <TableCell
      align={
        language.flow === "LTR" ? flow : flow === "right" ? "left" : "right"
      }
    >
      {children}
    </TableCell>
  );
};

export default AlignedTableCell;
