import { useTheme } from '@mui/material/styles';
import React from 'react';
import Iconify from 'src/components/Iconify';

const MuiIcon = ({ icon, width, height, ...props }) => {
  const theme = useTheme();
  return (
    <Iconify
      icon={icon}
      height={height}
      width={width}
      sx={{
        // marginRight: '5px',
        color: theme.palette.mode == 'dark' ? 'primary.main' : 'secondary.main',
      }}
    />
  );
};

export default MuiIcon;
