import React, { useEffect } from "react";
import PropTypes from "prop-types";
// material
import { styled } from "@mui/material/styles";
import { Toolbar, IconButton, TextField } from "@mui/material";
// component
import RestartAltIcon from "@mui/icons-material/RestartAlt";

import useLanguage from "../../../hooks/useLanguage";
import { AdapterDateFns } from "@mui/x-date-pickers/AdapterDateFns";
import { AdapterDayjs } from "@mui/x-date-pickers/AdapterDayjs";
import { DesktopDatePicker, LocalizationProvider } from "@mui/x-date-pickers";
// ----------------------------------------------------------------------

const RootStyle = styled(Toolbar)(({ theme }) => ({
  height: 96,
  display: "flex",
  justifyContent: "space-between",
  padding: theme.spacing(0, 1, 0, 3),
}));

// ----------------------------------------------------------------------
UcListRangToolber.propTypes = {
  filterAddress: PropTypes.string,
  onFilterAddress: PropTypes.func,
  onFilterName: PropTypes.func,
};

export default function UcListRangToolber({ onFilter }) {
  const [value, setValue] = React.useState({
    start_date: null,
    end_date: null,
  });

  const translate = useLanguage().translate;

  useEffect(() => {
    let start_date = value.start_date;
    
    let end_date = value.end_date;

    onFilter({ start_date, end_date });
  }, [value]);

  return (
    <RootStyle dir="ltr">
      <div style={{ display: "flex" }}>
        
        <LocalizationProvider dateAdapter={AdapterDayjs}>
          <DesktopDatePicker
            label={translate("From")}
            maxDate={new Date()}
            value={value.start_date}
            onChange={(newValue) => {
              setValue((pri) => ({ ...pri, start_date: newValue }));
            }}
            renderInput={(params) => <TextField {...params} />}
          />
        </LocalizationProvider>
        <p
          style={{
            alignSelf: "center",
            fontSize: "20px",
            padding: "10px",
          }}
        >
          to
        </p>
        <LocalizationProvider dateAdapter={AdapterDateFns}>
          <DesktopDatePicker
            maxDate={new Date()}
            label={translate("Till")}
            value={value.end_date}
            onChange={(newValue) => {
              setValue((pri) => ({
                ...pri,
                end_date: newValue,
              }));
            }}
            renderInput={(params) => <TextField {...params} />}
          />
        </LocalizationProvider>
        {value.start_date || value.end_date ? (
          <IconButton
            onClick={() => {
              setValue({
                start_date: null,
                end_date: null,
              });
            }}
            style={{ alignSelf: "center", margin: "5px" }}
          >
            <RestartAltIcon />
          </IconButton>
        ) : null}
      </div>
    </RootStyle>
  );
}
