import React from "react";
import * as Yup from "yup";
import { useFormik, Form, FormikProvider } from "formik";
// material
import { Stack, TextField } from "@mui/material";

import { useNavigate } from "react-router-dom";

import { LoadingButton } from "@mui/lab";

const RecoverPassForm = () => {
  const navigate = useNavigate();

  const LoginSchema = Yup.object().shape({
    email: Yup.string()
      .email("Email must be a valid email address")
      .required("Email is required"),
  });

  const formik = useFormik({
    initialValues: {
      email: "",
    },
    validationSchema: LoginSchema,
    onSubmit: async (e) => {
      //Call the api to reset the pass
      console.log(e.email);
    },
  });

  const { errors, touched, isSubmitting, handleSubmit, getFieldProps } = formik;

  return (
    <FormikProvider value={formik}>
      <Form autoComplete="off" noValidate onSubmit={handleSubmit}>
        <Stack spacing={3}>
          <TextField
            fullWidth
            autoComplete="username"
            type="email"
            label="Email address"
            {...getFieldProps("email")}
            error={Boolean(touched.email && errors.email)}
            helperText={touched.email && errors.email}
          />
        </Stack>
        <LoadingButton
          sx={{ my: 2 }}
          fullWidth
          size="large"
          type="submit"
          variant="contained"
          loading={isSubmitting}
        >
          Reset Password
        </LoadingButton>
        <Stack direction="row" alignItems="center" sx={{ mx: 2 }}>
          <LoadingButton fullWidth size="large" onClick={() => navigate("../")}>
            Back
          </LoadingButton>
        </Stack>
      </Form>
    </FormikProvider>
  );
};

export default RecoverPassForm;
