// routes
import Router from './routes';
// theme
import ThemeConfig from './theme';
import GlobalStyles from './theme/globalStyles';
// components
import ScrollToTop from './components/ScrollToTop';
import { BaseOptionChartStyle } from './components/charts/BaseOptionChart';
import axios from 'axios';

import { AuthProvider } from './hooks/useAuth';
import { DeviceProvider } from './hooks/useDeviceId';
import ProgressBar from './components/Bars/ProgressBar';
import { LanguageProvider } from './hooks/useLanguage';
import React from 'react';

axios.defaults.baseURL = process.env.REACT_APP_API_URL;

export default function App() {

  return (
    <AuthProvider>
      <DeviceProvider>
        <LanguageProvider>
          <ThemeConfig>
            <ScrollToTop />
            <GlobalStyles />
            <BaseOptionChartStyle />
            <ProgressBar />
            <Router />
          </ThemeConfig>
        </LanguageProvider>
      </DeviceProvider>
    </AuthProvider>
  );
}
  