import React, { useRef, useEffect, useState } from 'react';
import LoadingBar from 'react-top-loading-bar';
import axios from 'axios';
import useAuth from '../../hooks/useAuth';
const ProgressBar = () => {
  const [ProgressBar, setProgressBar] = useState(false);
  const ref = useRef(null);
  const { logout } = useAuth();

  // Add a request interceptor
  axios.interceptors.request.use(
    function (config) {
      config.headers.Authorization = `Bearer ${localStorage.getItem('token')}`;
      
     

      setProgressBar(true);
      // Do something before request is sent
      return config;
    },
    function (error) {
      setProgressBar(false);
      

      // Do something with request error
      return Promise.reject(error);
    }
  );

  // Add a response interceptor
  axios.interceptors.response.use(
    function (response) {
      setProgressBar(false);
      
      // Any status code that lie within the range of 2xx cause this function to trigger
      // Do something with response data
      return response;
    },
    function (error) {
      setProgressBar(false);
      
      if (error.response.status === 401) {
        logout();
      }

      // Any status codes that falls outside the range of 2xx cause this function to trigger
      // Do something with response error
      return Promise.reject(error);
    }
  );

  useEffect(() => {
    if (ProgressBar) {
      ref.current.continuousStart();
    } else {
      ref.current.complete();
    }
  }, [ProgressBar]);

  return <LoadingBar color='#AFD402' height={3} ref={ref} />;
};

export default ProgressBar;
