import {
  Button,
  Box,
  FormControl,
  InputLabel,
  Select,
  MenuItem,
  Modal,
  Card,
  Checkbox,
  FormControlLabel,
  Grid,
} from "@mui/material";
import React, { useState } from "react";
import TextField from "@mui/material/TextField";
import DialogActions from "@mui/material/DialogActions";
import DialogContent from "@mui/material/DialogContent";
import DialogContentText from "@mui/material/DialogContentText";
import DialogTitle from "@mui/material/DialogTitle";

import { DesktopDatePicker } from "@mui/x-date-pickers/DesktopDatePicker";
import { LocalizationProvider } from "@mui/x-date-pickers";
import { AdapterDayjs } from "@mui/x-date-pickers/AdapterDayjs";
import axios from "axios";

const CoupanDilog = ({ open, handleClose, update, defaultData }) => {
  const [formData, setFormData] = useState(defaultData);

  const [isError, setError] = useState(false);

  const handleSubmit = async () => {
    try {
      if (
        !formData.amount_type ||
        !formData.coupon_code ||
        !formData.amount ||
        !formData.expiry_date
      ) {
        setError(true);
        return;
      }

      await axios.post(update?`admin/coupon-update/${formData.id}`:`admin/coupons-store`, formData);

      handleClose(true);
    } catch (error) {
      console.log(error);
      handleClose();
    }
  };

  return (
    <Modal
      open={open}
      onClose={handleClose}
      aria-labelledby="modal-modal-title"
      aria-describedby="modal-modal-description"
    >
      <Card style={{ width: "50%", margin: "100px auto auto auto" }}>
        <div
          className="FormLayout"
          style={{
            width: "100%",
            margin: "auto",
          }}
        >
          <div>
            <DialogTitle>{update?"Update Coupan":"Create New Coupan"}</DialogTitle>

            <DialogContent>
              {isError ? (
                <DialogContentText color="red">
                  All Fields Must Be Field.
                </DialogContentText>
              ) : null}

              <Grid container spacing={2}>
                <Grid item xs={8}>
                  <TextField
                    fullWidth
                    autoFocus
                    margin="dense"
                    disabled={update}
                    id="coupon_code"
                    variant="outlined"
                    value={formData.coupon_code}
                    onChange={(e) =>
                      setFormData((data) => ({
                        ...data,
                        coupon_code: e.target.value,
                      }))
                    }
                    aria-errormessage="heklki"
                    label="Coupan Code"
                    type="text"
                  />
                </Grid>
                <Grid item xs={4}>
                  <Box sx={{ marginTop: "8px" }}>
                    <LocalizationProvider dateAdapter={AdapterDayjs}>
                      <DesktopDatePicker
                        label="Expiry Date"
                        inputFormat="MM/DD/YYYY"
                        value={formData.expiry_date}
                        onChange={(date) =>
                          setFormData((data) => ({
                            ...data,
                            expiry_date: date,
                          }))
                        }
                        renderInput={(params) => <TextField {...params} />}
                      />
                    </LocalizationProvider>
                  </Box>
                </Grid>
                <Grid item xs={8}>
                  <TextField
                    fullWidth
                    margin="dense"
                    id="amount"
                    variant="outlined"
                    label="Amount"
                    value={formData.amount}
                    onChange={(e) =>
                      setFormData((data) => ({
                        ...data,
                        amount: e.target.value,
                      }))
                    }
                    type="number"
                  />
                </Grid>
                <Grid item xs={4}>
                  <FormControl sx={{ width: "100%", marginTop: "8px" }}>
                    <InputLabel id="demo-simple-select-label">
                      Amount Type
                    </InputLabel>
                    <Select
                      labelId="demo-simple-select-label"
                      id="demo-simple-select"
                      value={formData.amount_type}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          amount_type: e.target.value,
                        }))
                      }
                      label="Amount Type"
                    >
                      <MenuItem value={"percentage"}>percentage</MenuItem>
                      <MenuItem value={"cash"}>cash</MenuItem>
                    </Select>
                  </FormControl>
                </Grid>
              </Grid>

              <Box>
                <FormControlLabel
                  control={
                    <Checkbox
                      size="large"
                      value={formData.status ? true : false}
                      defaultChecked={formData.status}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          status: e.target.checked ? 1 : 0,
                        }))
                      }
                    />
                  }
                  label="status"
                />
              </Box>

              <DialogActions>
                <Button
                  onClick={() => {
                    handleClose();
                  }}
                >
                  Cancel
                </Button>
                <Button onClick={handleSubmit}>{update?"update":"Add New"}</Button>
              </DialogActions>
            </DialogContent>
          </div>
        </div>
      </Card>
    </Modal>
  );
};

export default CoupanDilog;
