import React from "react";
import { useState, useRef } from "react";
// import song from './Suncrown - Legend of the Forgotten Centuries.mp3'
import Slider from "./slider/Slider";
import ControlPanel from "./controls/ControlPanel";
import "./AudioPlayer.css";

import Button from "./controls/Button";

const AudioPlayer = ({ item, setRuningSong, runingSong }) => {
  const [percentage, setPercentage] = useState(0);
  const [duration, setDuration] = useState(0);
  const [currentTime, setCurrentTime] = useState(0);

  const audioRef = useRef();

  const onChange = (e) => {
    const audio = audioRef.current;
    audio.currentTime = (audio.duration / 100) * e.target.value;
    setPercentage(e.target.value);
  };

  const play = () => {
    if (runingSong === item.id) {
      setRuningSong("");
    } else {
      setRuningSong(item.id);
    }
  };

  const getCurrDuration = (e) => {
    const percent = (
      (e.currentTarget.currentTime / e.currentTarget.duration) *
      100
    ).toFixed(2);
    const time = e.currentTarget.currentTime;

    setPercentage(+percent);
    setCurrentTime(time.toFixed(2));
  };

  if (item.id === runingSong) {
    audioRef.current.play();
  } else {
    if (audioRef.current) {
      audioRef.current.pause();
    }
  }

  return (
    <div className="app-container" dir="ltr">
      <div style={{ display: "flex", alignItems: "center" }}>
        <Button play={play} runingSong={runingSong} item={item} />
          <Slider percentage={percentage} onChange={onChange} />
        
      </div>
      <ControlPanel
            play={play}
            item={item}
            runingSong={runingSong}
            duration={duration}
            currentTime={currentTime}
          />
      <audio
        ref={audioRef}
        onTimeUpdate={getCurrDuration}
        loop
        onLoadedData={(e) => {
          setDuration(e.currentTarget.duration.toFixed(2));
        }}
        src={item.src}
      />
    </div>
  );
};

export default AudioPlayer;
