import {
  Stack,
  Typography,
  TableContainer,
  Table,
  TableBody,
  TableRow,
  TableCell,
  Checkbox,
  Button,
  TablePagination,
} from '@mui/material';
import React, { useEffect, useState } from 'react';
import Scrollbar from 'src/components/Scrollbar';
import useDeviceId from '../../hooks/useDeviceId';
import {
  UcListHead,
  UcListToolbar,
} from 'src/sections/@dashboard/utilityComponents';
import Iconify from 'src/components/Iconify';
import SearchNotFound from 'src/components/SearchNotFound';
import MapMpdleForGeo from 'src/components/GoogleMap/MapMpdleForGeo';
import axios from 'axios';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';

const TABLE_HEAD = [

  { id: 'id', label: 'id', alignRight: false },
  { id: 'map', label: 'MAP', alignRight: false },
  { id: 'area_name', label: 'AREA NAME', alignRight: false },
  { id: 'latitude', label: 'LATITUDE', alignRight: false },
  { id: 'longitude', label: 'LONGITUDE', alignRight: false },
  { id: 'radius', label: 'RADIUS', alignRight: true },
];

const SavedLocations = ({ update }) => {
  const [filter, setFilter] = useState('');
  const [selected, setSelected] = useState([]);
  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('address');
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [totalRow, setTotleRows] = useState(0);
  const [lanLongRed, setlanLongRed] = useState(null);
  const [dataList, setDataList] = useState([]);
  const { deviceID, setDeviceID } = useDeviceId();

  useEffect(async () => {
    try {
      const result = await axios.get(`fence-details/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      setTotleRows(result.data.data.total_count);
      setDataList(result.data.data.fence_data);
    } catch (error) {
      console.log(error);
    }
  }, [rowsPerPage, page, deviceID, filter, update]);

  const handleClose = () => setlanLongRed(null);

  const isLanLongAvailable = () => {
    if (lanLongRed !== null) {
      return true;
    } else {
      return false;
    }
  };
  const filterdata = applySortFilter(
    dataList,
    getComparator(order, orderBy),
    filter
  );

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }
  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[2].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = dataList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };
  const isUserNotFound = dataList.length === 0;
  return (
    <>
      <UcListToolbar
        onSort={sortAll}
        placeholder='Search By Address...'
        numSelected={selected.length}
        onFilter={(value) => setFilter(value)}
      />
      <Scrollbar>
        <>
          <TableContainer sx={{ minWidth: 800 }}>
            <Table>
              <UcListHead
                order={order}
                orderBy={orderBy}
                headLabel={TABLE_HEAD}
                rowCount={dataList.length}
                numSelected={selected.length}
                onRequestSort={handleRequestSort}
                onSelectAllClick={handleSelectAllClick}
              />
              <TableBody>
                {filterdata.map((row) => {
                  const { id, latitude, longitude, area_name, radius, action } =
                    row;
                  const isItemSelected = selected.indexOf(id) !== -1;

                  return (
                    <TableRow
                      hover
                      key={id}
                      tabIndex={-1}
                      role='checkbox'
                      selected={isItemSelected}
                      aria-checked={isItemSelected}
                    >
                      <AlignedTableCell flow='left'>
                        {id}
                      </AlignedTableCell>
                      <TableCell component='th' scope='row' padding='none'>
                        <Stack direction='row' alignItems='center' spacing={2}>
                          <Typography variant='subtitle2' noWrap>
                            <Button
                              onClick={() => {
                                setlanLongRed({
                                  // Functional
                                  lat: latitude,
                                  lang: longitude,
                                  radius: radius,
                                });
                                // setlanLong({
                                //   lat: "40.427260",
                                //   lang: "-74.483840",
                                // });
                              }}
                              // variant="contained"
                            >
                              View Map
                            </Button>
                          </Typography>
                        </Stack>
                      </TableCell>

                      <AlignedTableCell flow='left'>
                        <Typography variant='subtitle2' noWrap>
                          <Iconify icon='akar-icons:location' />
                          {area_name}
                        </Typography>
                      </AlignedTableCell>
                      <AlignedTableCell flow='left'>
                        {latitude}
                      </AlignedTableCell>
                      <AlignedTableCell flow='left'>
                        {longitude}
                      </AlignedTableCell>
                      <AlignedTableCell flow='right'>
                        {radius}Km
                      </AlignedTableCell>
                    </TableRow>
                  );
                })}
              </TableBody>
              {isUserNotFound && (
                <TableBody>
                  <TableRow>
                    <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                      <SearchNotFound searchQuery={filter} />
                    </TableCell>
                  </TableRow>
                </TableBody>
              )}
            </Table>
          </TableContainer>
          {lanLongRed ? (
            <MapMpdleForGeo
              handleClose={handleClose}
              isLanLongAvailable={isLanLongAvailable}
              lanLongRed={lanLongRed}
            />
          ) : null}
        </>
      </Scrollbar>
      <MyTablePagination
        count={totalRow}
        rowsPerPage={rowsPerPage}
        page={page}
        setPage={setPage}
        setRowsPerPage={setRowsPerPage}
      />
    </>
  );
};

export default SavedLocations;
